/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.flat.train.prop;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.flat.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkBackPropagation
extends TrainFlatNetworkProp {
    private double learningRate;
    private double momentum;
    private double[] lastDelta;

    public TrainFlatNetworkBackPropagation(FlatNetwork network, MLDataSet training, double theLearningRate, double theMomentum) {
        super(network, training);
        this.momentum = theMomentum;
        this.learningRate = theLearningRate;
        this.lastDelta = new double[network.getWeights().length];
    }

    public final double[] getLastDelta() {
        return this.lastDelta;
    }

    public final double getLearningRate() {
        return this.learningRate;
    }

    public final double getMomentum() {
        return this.momentum;
    }

    public final void setLastDelta(double[] ds) {
        this.lastDelta = ds;
    }

    public final void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    public final void setMomentum(double rate) {
        this.momentum = rate;
    }

    @Override
    public final double updateWeight(double[] gradients, double[] lastGradient, int index) {
        double delta;
        this.lastDelta[index] = delta = gradients[index] * this.learningRate + this.lastDelta[index] * this.momentum;
        return delta;
    }

    @Override
    public void initOthers() {
    }
}

