/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.manhattan;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.train.prop.TrainFlatNetworkManhattan;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class ManhattanPropagation
extends Propagation
implements LearningRate {
    static final double DEFAULT_ZERO_TOLERANCE = 0.001;

    public ManhattanPropagation(ContainsFlat network, MLDataSet training, double learnRate) {
        super(network, training);
        this.setFlatTraining(new TrainFlatNetworkManhattan(network.getFlat(), this.getTraining(), learnRate));
    }

    @Override
    public final double getLearningRate() {
        return ((TrainFlatNetworkManhattan)this.getFlatTraining()).getLearningRate();
    }

    @Override
    public final void setLearningRate(double rate) {
        ((TrainFlatNetworkManhattan)this.getFlatTraining()).setLearningRate(rate);
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    @Override
    public final TrainingContinuation pause() {
        return null;
    }

    @Override
    public final void resume(TrainingContinuation state) {
    }
}

