/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.prop;

import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.script.prop.PropertyType;
import org.encog.app.analyst.util.ConvertStringConst;

public class PropertyEntry
implements Comparable<PropertyEntry> {
    private final PropertyType entryType;
    private final String name;
    private final String section;

    public static String dotForm(String section, String subSection, String name) {
        StringBuilder result = new StringBuilder();
        result.append(section);
        result.append('.');
        result.append(subSection);
        result.append('.');
        result.append(name);
        return result.toString();
    }

    public PropertyEntry(PropertyType theEntryType, String theName, String theSection) {
        this.entryType = theEntryType;
        this.name = theName;
        this.section = theSection;
    }

    @Override
    public final int compareTo(PropertyEntry o) {
        return this.name.compareTo(o.name);
    }

    public final PropertyType getEntryType() {
        return this.entryType;
    }

    public final String getKey() {
        return this.section + "_" + this.name;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSection() {
        return this.section;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" name=");
        result.append(this.name);
        result.append(", section=");
        result.append(this.section);
        result.append("]");
        return result.toString();
    }

    public final void validate(String theSection, String subSection, String theName, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            switch (this.getEntryType()) {
                case TypeBoolean: {
                    if (Character.toUpperCase(value.charAt(0)) != 'T' && Character.toUpperCase(value.charAt(0)) != 'F') {
                        StringBuilder result = new StringBuilder();
                        result.append("Illegal boolean for ");
                        result.append(PropertyEntry.dotForm(this.section, subSection, this.name));
                        result.append(", value is ");
                        result.append(value);
                        result.append(".");
                        throw new AnalystError(result.toString());
                    }
                    break;
                }
                case TypeDouble: {
                    Double.parseDouble(value);
                    break;
                }
                case typeFormat: {
                    if (ConvertStringConst.string2AnalystFileFormat(value) == null) {
                        StringBuilder result = new StringBuilder();
                        result.append("Invalid file format for ");
                        result.append(PropertyEntry.dotForm(this.section, subSection, this.name));
                        result.append(", value is ");
                        result.append(value);
                        result.append(".");
                        throw new AnalystError(result.toString());
                    }
                    break;
                }
                case TypeInteger: {
                    Integer.parseInt(value);
                    break;
                }
                case TypeListString: {
                    break;
                }
                case TypeString: {
                    break;
                }
                default: {
                    throw new AnalystError("Unsupported property type.");
                }
            }
        }
        catch (NumberFormatException ex) {
            StringBuilder result = new StringBuilder();
            result.append("Illegal value for ");
            result.append(PropertyEntry.dotForm(this.section, subSection, this.name));
            result.append(", expecting a ");
            result.append(this.getEntryType().toString());
            result.append(", but got ");
            result.append(value);
            result.append(".");
            throw new AnalystError(result.toString());
        }
    }
}

