/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;

public class NguyenWidrowRandomizer
extends RangeRandomizer
implements Randomizer {
    private int inputCount;
    private double beta;

    public NguyenWidrowRandomizer(double min, double max) {
        super(min, max);
    }

    @Override
    public final void randomize(MLMethod method) {
        if (!(method instanceof BasicNetwork)) {
            throw new EncogError("Ngyyen Widrow only works on BasicNetwork.");
        }
        BasicNetwork network = (BasicNetwork)method;
        new RangeRandomizer(this.getMin(), this.getMax()).randomize(network);
        int hiddenNeurons = 0;
        for (int i = 1; i < network.getLayerCount() - 1; ++i) {
            hiddenNeurons += network.getLayerNeuronCount(i);
        }
        if (hiddenNeurons < 1) {
            return;
        }
        this.inputCount = network.getInputCount();
        this.beta = 0.7 * Math.pow(hiddenNeurons, 1.0 / (double)network.getInputCount());
        super.randomize(network);
    }

    @Override
    public void randomize(BasicNetwork network, int fromLayer) {
        int fromCount = network.getLayerTotalNeuronCount(fromLayer);
        int toCount = network.getLayerNeuronCount(fromLayer + 1);
        for (int toNeuron = 0; toNeuron < toCount; ++toNeuron) {
            double w;
            int fromNeuron;
            double n = 0.0;
            for (fromNeuron = 0; fromNeuron < fromCount; ++fromNeuron) {
                w = network.getWeight(fromLayer, fromNeuron, toNeuron);
                n += w * w;
            }
            n = Math.sqrt(n);
            for (fromNeuron = 0; fromNeuron < fromCount; ++fromNeuron) {
                w = network.getWeight(fromLayer, fromNeuron, toNeuron);
                w = this.beta * w / n;
                network.setWeight(fromLayer, fromNeuron, toNeuron, w);
            }
        }
    }
}

