/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import org.encog.mathutil.ComplexNumber;
import org.encog.ml.data.MLComplexData;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;

public class BasicMLComplexData
implements MLComplexData {
    private ComplexNumber[] data;

    public BasicMLComplexData(double[] d) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BasicMLComplexData(ComplexNumber[] d) {
        this.data = d;
    }

    public BasicMLComplexData(int size) {
        this.data = new ComplexNumber[size];
    }

    public BasicMLComplexData(MLData d) {
        this(d.size());
        if (d instanceof MLComplexData) {
            MLComplexData c = (MLComplexData)d;
            for (int i = 0; i < d.size(); ++i) {
                this.data[i] = new ComplexNumber(c.getComplexData(i));
            }
        } else {
            for (int i = 0; i < d.size(); ++i) {
                this.data[i] = new ComplexNumber(d.getData(i), 0.0);
            }
        }
    }

    @Override
    public final void add(int index, double value) {
        this.data[index].plus(new ComplexNumber(value, 0.0));
    }

    @Override
    public final void add(int index, ComplexNumber value) {
        this.data[index] = this.data[index].plus(value);
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ComplexNumber(0.0, 0.0);
        }
    }

    @Override
    public final MLData clone() {
        return new BasicMLData(this);
    }

    @Override
    public final double[] getData() {
        double[] d = new double[this.data.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.data[i].getReal();
        }
        return d;
    }

    @Override
    public final ComplexNumber[] getComplexData() {
        return this.data;
    }

    @Override
    public final double getData(int index) {
        return this.data[index].getReal();
    }

    @Override
    public final ComplexNumber getComplexData(int index) {
        return this.data[index];
    }

    @Override
    public final void setData(double[] theData) {
        for (int i = 0; i < theData.length; ++i) {
            this.data[i] = new ComplexNumber(theData[i], 0.0);
        }
    }

    @Override
    public final void setData(ComplexNumber[] theData) {
        this.data = theData;
    }

    @Override
    public final void setData(int index, double d) {
        this.data[index] = new ComplexNumber(d, 0.0);
    }

    @Override
    public final void setData(int index, ComplexNumber d) {
        this.data[index] = d;
    }

    @Override
    public final int size() {
        return this.data.length;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.data[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

