/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer.codec;

import java.util.Iterator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.buffer.codec.DataSetCODEC;
import org.encog.util.EngineArray;

public class NeuralDataSetCODEC
implements DataSetCODEC {
    private int inputSize;
    private int idealSize;
    private MLDataSet dataset;
    private Iterator<MLDataPair> iterator;

    public NeuralDataSetCODEC(MLDataSet theDataset) {
        this.dataset = theDataset;
        this.inputSize = theDataset.getInputSize();
        this.idealSize = theDataset.getIdealSize();
    }

    @Override
    public final int getInputSize() {
        return this.inputSize;
    }

    @Override
    public final int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public final boolean read(double[] input, double[] ideal, double[] significance) {
        if (!this.iterator.hasNext()) {
            return false;
        }
        MLDataPair pair = this.iterator.next();
        EngineArray.arrayCopy(pair.getInputArray(), input);
        EngineArray.arrayCopy(pair.getIdealArray(), ideal);
        significance[0] = pair.getSignificance();
        return true;
    }

    @Override
    public final void write(double[] input, double[] ideal, double significance) {
        MLDataPair pair = BasicMLDataPair.createPair(this.inputSize, this.idealSize);
        EngineArray.arrayCopy(input, pair.getIdealArray());
        EngineArray.arrayCopy(ideal, pair.getIdealArray());
        pair.setSignificance(significance);
    }

    @Override
    public final void prepareWrite(int recordCount, int theInputSize, int theIdealSize) {
        this.inputSize = theInputSize;
        this.idealSize = theIdealSize;
    }

    @Override
    public final void prepareRead() {
        this.iterator = this.dataset.iterator();
    }

    @Override
    public void close() {
    }
}

