/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.temporal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.temporal.TemporalDataDescription;
import org.encog.ml.data.temporal.TemporalError;
import org.encog.ml.data.temporal.TemporalPoint;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.util.time.TimeSpan;
import org.encog.util.time.TimeUnit;

public class TemporalMLDataSet
extends BasicNeuralDataSet
implements Serializable {
    private static final long serialVersionUID = 7846736117000051687L;
    public static final String ADD_NOT_SUPPORTED = "Direct adds to the temporal dataset are not supported.  Add TemporalPoint objects and call generate.";
    private final List<TemporalDataDescription> descriptions = new ArrayList<TemporalDataDescription>();
    private final List<TemporalPoint> points = new ArrayList<TemporalPoint>();
    private int inputWindowSize;
    private int predictWindowSize;
    private int lowSequence;
    private int highSequence;
    private int desiredSetSize;
    private int inputNeuronCount;
    private int outputNeuronCount;
    private Date startingPoint;
    private TimeUnit sequenceGrandularity;

    public TemporalMLDataSet(int inputWindowSize, int predictWindowSize) {
        this.inputWindowSize = inputWindowSize;
        this.predictWindowSize = predictWindowSize;
        this.lowSequence = Integer.MIN_VALUE;
        this.highSequence = Integer.MAX_VALUE;
        this.desiredSetSize = Integer.MAX_VALUE;
        this.startingPoint = null;
        this.sequenceGrandularity = TimeUnit.DAYS;
    }

    @Override
    public void add(MLData data) {
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(MLDataPair inputData) {
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    public void addDescription(TemporalDataDescription desc) {
        if (this.points.size() > 0) {
            String str = "Can't add anymore descriptions, there are already temporal points defined.";
            throw new TemporalError("Can't add anymore descriptions, there are already temporal points defined.");
        }
        int index = this.descriptions.size();
        desc.setIndex(index);
        this.descriptions.add(desc);
        this.calculateNeuronCounts();
    }

    public int calculateActualSetSize() {
        int result = this.calculatePointsInRange();
        result = Math.min(this.desiredSetSize, result);
        return result;
    }

    public void calculateNeuronCounts() {
        this.inputNeuronCount = 0;
        this.outputNeuronCount = 0;
        for (TemporalDataDescription desc : this.descriptions) {
            if (desc.isInput()) {
                this.inputNeuronCount += this.inputWindowSize;
            }
            if (!desc.isPredict()) continue;
            this.outputNeuronCount += this.predictWindowSize;
        }
    }

    public int calculatePointsInRange() {
        int result = 0;
        for (TemporalPoint point : this.points) {
            if (!this.isPointInRange(point)) continue;
            ++result;
        }
        return result;
    }

    public int calculateStartIndex() {
        for (int i = 0; i < this.points.size(); ++i) {
            TemporalPoint point = this.points.get(i);
            if (!this.isPointInRange(point)) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.descriptions.clear();
        this.points.clear();
        this.getData().clear();
    }

    public TemporalPoint createPoint(Date when) {
        int sequence = this.getSequenceFromDate(when);
        TemporalPoint point = new TemporalPoint(this.descriptions.size());
        point.setSequence(sequence);
        this.points.add(point);
        return point;
    }

    public TemporalPoint createPoint(int sequence) {
        TemporalPoint point = new TemporalPoint(this.descriptions.size());
        point.setSequence(sequence);
        this.points.add(point);
        return point;
    }

    private double formatData(TemporalDataDescription desc, int index) {
        double[] result = new double[1];
        switch (desc.getType()) {
            case DELTA_CHANGE: {
                result[0] = this.getDataDeltaChange(desc, index);
                break;
            }
            case PERCENT_CHANGE: {
                result[0] = this.getDataPercentChange(desc, index);
                break;
            }
            case RAW: {
                result[0] = this.getDataRAW(desc, index);
                break;
            }
            default: {
                throw new TemporalError("Unsupported data type.");
            }
        }
        if (desc.getActivationFunction() != null) {
            desc.getActivationFunction().activationFunction(result, 0, result.length);
        }
        return result[0];
    }

    public void generate() {
        this.sortPoints();
        int start = this.calculateStartIndex() + 1;
        int setSize = this.calculateActualSetSize();
        int range = start + setSize - this.predictWindowSize - this.inputWindowSize;
        for (int i = start; i < range; ++i) {
            BasicNeuralData input = this.generateInputNeuralData(i);
            BasicNeuralData ideal = this.generateOutputNeuralData(i + this.inputWindowSize);
            BasicMLDataPair pair = new BasicMLDataPair(input, ideal);
            super.add(pair);
        }
    }

    public BasicNeuralData generateInputNeuralData(int index) {
        if (index + this.inputWindowSize > this.points.size()) {
            throw new TemporalError("Can't generate input temporal data beyond the end of provided data.");
        }
        BasicNeuralData result = new BasicNeuralData(this.inputNeuronCount);
        int resultIndex = 0;
        for (int i = 0; i < this.inputWindowSize; ++i) {
            int descriptionIndex = 0;
            for (TemporalDataDescription desc : this.descriptions) {
                if (desc.isInput()) {
                    result.setData(resultIndex++, this.formatData(desc, index + i));
                }
                ++descriptionIndex;
            }
        }
        return result;
    }

    public BasicNeuralData generateOutputNeuralData(int index) {
        if (index + this.predictWindowSize > this.points.size()) {
            String str = "Can't generate prediction temporal data beyond the end of provided data.";
            throw new TemporalError("Can't generate prediction temporal data beyond the end of provided data.");
        }
        BasicNeuralData result = new BasicNeuralData(this.outputNeuronCount);
        int resultIndex = 0;
        for (int i = 0; i < this.predictWindowSize; ++i) {
            int descriptionIndex = 0;
            for (TemporalDataDescription desc : this.descriptions) {
                if (desc.isPredict()) {
                    result.setData(resultIndex++, this.formatData(desc, index + i));
                }
                ++descriptionIndex;
            }
        }
        return result;
    }

    private double getDataDeltaChange(TemporalDataDescription desc, int index) {
        if (index == 0) {
            return 0.0;
        }
        TemporalPoint point = this.points.get(index);
        TemporalPoint previousPoint = this.points.get(index - 1);
        return point.getData(desc.getIndex()) - previousPoint.getData(desc.getIndex());
    }

    private double getDataPercentChange(TemporalDataDescription desc, int index) {
        if (index == 0) {
            return 0.0;
        }
        TemporalPoint point = this.points.get(index);
        TemporalPoint previousPoint = this.points.get(index - 1);
        double currentValue = point.getData(desc.getIndex());
        double previousValue = previousPoint.getData(desc.getIndex());
        return (currentValue - previousValue) / previousValue;
    }

    private double getDataRAW(TemporalDataDescription desc, int index) {
        TemporalPoint point = this.points.get(index - 1);
        return point.getData(desc.getIndex());
    }

    public List<TemporalDataDescription> getDescriptions() {
        return this.descriptions;
    }

    public int getDesiredSetSize() {
        return this.desiredSetSize;
    }

    public int getHighSequence() {
        return this.highSequence;
    }

    public int getInputNeuronCount() {
        return this.inputNeuronCount;
    }

    public int getInputWindowSize() {
        return this.inputWindowSize;
    }

    public int getLowSequence() {
        return this.lowSequence;
    }

    public int getOutputNeuronCount() {
        return this.outputNeuronCount;
    }

    public List<TemporalPoint> getPoints() {
        return this.points;
    }

    public int getPredictWindowSize() {
        return this.predictWindowSize;
    }

    public int getSequenceFromDate(Date when) {
        int sequence;
        if (this.startingPoint != null) {
            TimeSpan span = new TimeSpan(this.startingPoint, when);
            sequence = (int)span.getSpan(this.sequenceGrandularity);
        } else {
            this.startingPoint = when;
            sequence = 0;
        }
        return sequence;
    }

    public TimeUnit getSequenceGrandularity() {
        return this.sequenceGrandularity;
    }

    public Date getStartingPoint() {
        return this.startingPoint;
    }

    public boolean isPointInRange(TemporalPoint point) {
        return point.getSequence() >= this.getLowSequence() && point.getSequence() <= this.getHighSequence();
    }

    public void setDesiredSetSize(int desiredSetSize) {
        this.desiredSetSize = desiredSetSize;
    }

    public void setHighSequence(int highSequence) {
        this.highSequence = highSequence;
    }

    public void setInputWindowSize(int inputWindowSize) {
        this.inputWindowSize = inputWindowSize;
    }

    public void setLowSequence(int lowSequence) {
        this.lowSequence = lowSequence;
    }

    public void setPredictWindowSize(int predictWindowSize) {
        this.predictWindowSize = predictWindowSize;
    }

    public void setSequenceGrandularity(TimeUnit sequenceGrandularity) {
        this.sequenceGrandularity = sequenceGrandularity;
    }

    public void setStartingPoint(Date startingPoint) {
        this.startingPoint = startingPoint;
    }

    public void sortPoints() {
        Collections.sort(this.points);
    }
}

