/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.population;

import java.io.Serializable;
import java.util.List;
import org.encog.ml.genetic.GeneticAlgorithm;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.innovation.InnovationList;
import org.encog.ml.genetic.species.Species;

public interface Population
extends Serializable {
    public static final String PROPERTY_NEXT_GENE_ID = "nextGeneID";
    public static final String PROPERTY_NEXT_GENOME_ID = "nextGenomeID";
    public static final String PROPERTY_NEXT_INNOVATION_ID = "nextInnovationID";
    public static final String PROPERTY_NEXT_SPECIES_ID = "nextSpeciesID";
    public static final String PROPERTY_OLD_AGE_PENALTY = "oldAgePenalty";
    public static final String PROPERTY_OLD_AGE_THRESHOLD = "oldAgeThreshold";
    public static final String PROPERTY_POPULATION_SIZE = "populationSize";
    public static final String PROPERTY_SURVIVAL_RATE = "survivalRate";
    public static final String PROPERTY_YOUNG_AGE_BONUS = "youngAgeBonus";
    public static final String PROPERTY_YOUNG_AGE_THRESHOLD = "youngAgeThreshold";
    public static final String PROPERTY_GENOMES = "genomes";
    public static final String PROPERTY_INNOVATIONS = "innovations";
    public static final String PROPERTY_SPECIES = "species";

    public void add(Genome var1);

    public void addAll(List<? extends Genome> var1);

    public long assignGeneID();

    public long assignGenomeID();

    public long assignInnovationID();

    public long assignSpeciesID();

    public void clear();

    public Genome get(int var1);

    public Genome getBest();

    public List<Genome> getGenomes();

    public InnovationList getInnovations();

    public double getOldAgePenalty();

    public int getOldAgeThreshold();

    public int getPopulationSize();

    public List<Species> getSpecies();

    public double getSurvivalRate();

    public int getYoungBonusAgeThreshold();

    public double getYoungScoreBonus();

    public void setInnovations(InnovationList var1);

    public void setOldAgePenalty(double var1);

    public void setOldAgeThreshold(int var1);

    public void setPopulationSize(int var1);

    public void setSurvivalRate(double var1);

    public void setYoungBonusAgeThreshhold(int var1);

    public void setYoungScoreBonus(double var1);

    public int size();

    public void sort();

    public void claim(GeneticAlgorithm var1);
}

