/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.kmeans;

import org.encog.ml.MLCluster;
import org.encog.ml.MLClustering;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.kmeans.Centroid;
import org.encog.ml.kmeans.KMeansCluster;

public class KMeansClustering
implements MLClustering {
    private final KMeansCluster[] clusters;
    private final MLDataSet set;
    private double wcss;

    public static double calculateEuclideanDistance(Centroid c, MLData data) {
        double[] d = data.getData();
        double sum = 0.0;
        for (int i = 0; i < c.getCenters().length; ++i) {
            sum += Math.pow(d[i] - c.getCenters()[i], 2.0);
        }
        return Math.sqrt(sum);
    }

    public KMeansClustering(int k, MLDataSet theSet) {
        this.clusters = new KMeansCluster[k];
        for (int i = 0; i < k; ++i) {
            this.clusters[i] = new KMeansCluster();
        }
        this.set = theSet;
        this.setInitialCentroids();
        int clusterNumber = 0;
        for (MLDataPair pair : this.set) {
            this.clusters[clusterNumber].add(pair.getInput());
            if (++clusterNumber < this.clusters.length) continue;
            clusterNumber = 0;
        }
        this.calcWCSS();
        for (KMeansCluster element : this.clusters) {
            element.getCentroid().calcCentroid();
        }
        this.calcWCSS();
    }

    private void calcWCSS() {
        double temp = 0.0;
        for (KMeansCluster element : this.clusters) {
            temp += element.getSumSqr();
        }
        this.wcss = temp;
    }

    @Override
    public final MLCluster[] getClusters() {
        return this.clusters;
    }

    private double getMaxValue(int index) {
        double result = Double.MIN_VALUE;
        long count = this.set.getRecordCount();
        int i = 0;
        while ((long)i < count) {
            MLDataPair pair = BasicMLDataPair.createPair(this.set.getInputSize(), this.set.getIdealSize());
            this.set.getRecord(i, pair);
            result = Math.max(result, pair.getInputArray()[index]);
            ++i;
        }
        return result;
    }

    private double getMinValue(int index) {
        double result = Double.MAX_VALUE;
        long count = this.set.getRecordCount();
        MLDataPair pair = BasicMLDataPair.createPair(this.set.getInputSize(), this.set.getIdealSize());
        int i = 0;
        while ((long)i < count) {
            this.set.getRecord(i, pair);
            result = Math.min(result, pair.getInputArray()[index]);
            ++i;
        }
        return result;
    }

    public final double getWCSS() {
        return this.wcss;
    }

    @Override
    public final void iteration() {
        for (KMeansCluster element : this.clusters) {
            for (int k = 0; k < element.size(); ++k) {
                MLData data = element.get(k);
                double distance = KMeansClustering.calculateEuclideanDistance(element.getCentroid(), data);
                KMeansCluster tempCluster = null;
                boolean match = false;
                for (KMeansCluster cluster : this.clusters) {
                    double d = KMeansClustering.calculateEuclideanDistance(cluster.getCentroid(), element.get(k));
                    if (!(distance > d)) continue;
                    distance = d;
                    tempCluster = cluster;
                    match = true;
                }
                if (!match) continue;
                tempCluster.add(element.get(k));
                element.remove(element.get(k));
                for (KMeansCluster element2 : this.clusters) {
                    element2.getCentroid().calcCentroid();
                }
                this.calcWCSS();
            }
        }
    }

    @Override
    public final void iteration(int count) {
        for (int i = 0; i < count; ++i) {
            this.iteration();
        }
    }

    @Override
    public final int numClusters() {
        return this.clusters.length;
    }

    private void setInitialCentroids() {
        for (int n = 1; n <= this.clusters.length; ++n) {
            double[] temp = new double[this.set.getInputSize()];
            for (int j = 0; j < temp.length; ++j) {
                temp[j] = (this.getMaxValue(j) - this.getMinValue(j)) / (double)(this.clusters.length + 1) * (double)n + this.getMinValue(j);
            }
            Centroid c1 = new Centroid(temp);
            this.clusters[n - 1].setCentroid(c1);
            c1.setCluster(this.clusters[n - 1]);
        }
    }
}

