/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.art;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.art.ART1;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistART1
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "ART1";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        ART1 result = new ART1();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("ART1") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("ART1") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setA1(EncogFileSection.parseDouble(params, "A1"));
            result.setB1(EncogFileSection.parseDouble(params, "B1"));
            result.setC1(EncogFileSection.parseDouble(params, "C1"));
            result.setD1(EncogFileSection.parseDouble(params, "D1"));
            result.setF1Count(EncogFileSection.parseInt(params, "f1Count"));
            result.setF2Count(EncogFileSection.parseInt(params, "f2Count"));
            result.setNoWinner(EncogFileSection.parseInt(params, "noWinner"));
            result.setL(EncogFileSection.parseDouble(params, "L"));
            result.setVigilance(EncogFileSection.parseDouble(params, "VIGILANCE"));
            result.setWeightsF1toF2(EncogFileSection.parseMatrix(params, "weightsF1F2"));
            result.setWeightsF2toF1(EncogFileSection.parseMatrix(params, "weightsF2F1"));
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        ART1 art1 = (ART1)obj;
        out.addSection("ART1");
        out.addSubSection("PARAMS");
        out.addProperties(art1.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("A1", art1.getA1());
        out.writeProperty("B1", art1.getB1());
        out.writeProperty("C1", art1.getC1());
        out.writeProperty("D1", art1.getD1());
        out.writeProperty("f1Count", art1.getF1Count());
        out.writeProperty("f2Count", art1.getF2Count());
        out.writeProperty("noWinner", art1.getNoWinner());
        out.writeProperty("L", art1.getL());
        out.writeProperty("VIGILANCE", art1.getVigilance());
        out.writeProperty("weightsF1F2", art1.getWeightsF1toF2());
        out.writeProperty("weightsF2F1", art1.getWeightsF2toF1());
        out.flush();
    }
}

