/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.cpn;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.ConsistentRandomizer;
import org.encog.ml.BasicML;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.simple.EncogUtility;

public class CPN
extends BasicML
implements MLRegression,
MLResettable,
MLError {
    private static final long serialVersionUID = 1L;
    private final int inputCount;
    private final int instarCount;
    private final int outstarCount;
    private final int winnerCount;
    private final Matrix weightsInputToInstar;
    private final Matrix weightsInstarToOutstar;

    public CPN(int theInputCount, int theInstarCount, int theOutstarCount, int theWinnerCount) {
        this.inputCount = theInputCount;
        this.instarCount = theInstarCount;
        this.outstarCount = theOutstarCount;
        this.weightsInputToInstar = new Matrix(this.inputCount, this.instarCount);
        this.weightsInstarToOutstar = new Matrix(this.instarCount, this.outstarCount);
        this.winnerCount = theWinnerCount;
    }

    @Override
    public final double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public final MLData compute(MLData input) {
        MLData temp = this.computeInstar(input);
        return this.computeOutstar(temp);
    }

    public final MLData computeInstar(MLData input) {
        int i;
        BasicMLData result = new BasicMLData(this.instarCount);
        int winner = 0;
        boolean[] winners = new boolean[this.instarCount];
        for (i = 0; i < this.instarCount; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.inputCount; ++j) {
                sum += this.weightsInputToInstar.get(j, i) * input.getData(j);
            }
            result.setData(i, sum);
            winners[i] = false;
        }
        double sumWinners = 0.0;
        for (int w = 0; w < this.winnerCount; ++w) {
            double maxOut = Double.MIN_VALUE;
            for (i = 0; i < this.instarCount; ++i) {
                if (winners[i] || !(result.getData(i) > maxOut)) continue;
                winner = i;
                maxOut = result.getData(winner);
            }
            winners[winner] = true;
            sumWinners += result.getData(winner);
        }
        for (i = 0; i < this.instarCount; ++i) {
            if (winners[i] && Math.abs(sumWinners) > 1.0E-13) {
                double[] dArray = result.getData();
                int n = i;
                dArray[n] = dArray[n] / sumWinners;
                continue;
            }
            result.getData()[i] = 0.0;
        }
        return result;
    }

    public final MLData computeOutstar(MLData input) {
        BasicMLData result = new BasicMLData(this.outstarCount);
        double sum = 0.0;
        for (int i = 0; i < this.outstarCount; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.instarCount; ++j) {
                sum += this.weightsInstarToOutstar.get(j, i) * input.getData(j);
            }
            result.setData(i, sum);
        }
        return result;
    }

    @Override
    public final int getInputCount() {
        return this.inputCount;
    }

    public final int getInstarCount() {
        return this.instarCount;
    }

    @Override
    public final int getOutputCount() {
        return this.outstarCount;
    }

    public final int getOutstarCount() {
        return this.outstarCount;
    }

    public final Matrix getWeightsInputToInstar() {
        return this.weightsInputToInstar;
    }

    public final Matrix getWeightsInstarToOutstar() {
        return this.weightsInstarToOutstar;
    }

    public final int getWinnerCount() {
        return this.winnerCount;
    }

    @Override
    public final void reset() {
        this.reset(0);
    }

    @Override
    public final void reset(int seed) {
        ConsistentRandomizer randomize = new ConsistentRandomizer(-1.0, 1.0, seed);
        randomize.randomize(this.weightsInputToInstar);
        randomize.randomize(this.weightsInstarToOutstar);
    }

    @Override
    public void updateProperties() {
    }
}

