/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.back.Backpropagation;

public class BPROPJob
extends TrainingJob {
    private double learningRate;
    private double momentum;

    public BPROPJob(BasicNetwork network, MLDataSet training, boolean loadToMemory, double learningRate, double momentum) {
        super(network, training, loadToMemory);
        this.learningRate = learningRate;
        this.momentum = momentum;
    }

    @Override
    public final void createTrainer(boolean singleThreaded) {
        Backpropagation train = new Backpropagation(this.getNetwork(), this.getTraining(), this.getLearningRate(), this.getMomentum());
        if (singleThreaded) {
            train.setThreadCount(1);
        } else {
            train.setThreadCount(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            train.addStrategy(strategy);
        }
        this.setTrain(train);
    }

    public final double getLearningRate() {
        return this.learningRate;
    }

    public final double getMomentum() {
        return this.momentum;
    }

    public final void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public final void setMomentum(double momentum) {
        this.momentum = momentum;
    }
}

