/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.lma;

import org.encog.mathutil.EncogMath;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.validate.ValidateNetwork;

public class LevenbergMarquardtTraining
extends BasicTraining {
    public static final double SCALE_LAMBDA = 10.0;
    public static final double LAMBDA_MAX = 1.0E25;
    public static final int NUM_POINTS = 3;
    private final BasicNetwork network;
    private final MLDataSet indexableTraining;
    private final int trainingLength;
    private final int parametersLength;
    private double[] weights;
    private final Matrix hessianMatrix;
    private final double[][] jacobian;
    private final double[][] hessian;
    private final double beta;
    private double lambda;
    private final double[] gradient;
    private final double[] diagonal;
    private double[] deltas;
    private double gamma;
    private final MLDataPair pair;
    private final double[] derivativeStepSize;
    private final double[][][] differentialCoefficients;
    private final double DERIV_STEP = 0.01;
    private final double[] errors;

    public static double trace(double[][] m) {
        double result = 0.0;
        for (int i = 0; i < m.length; ++i) {
            result += m[i][i];
        }
        return result;
    }

    public LevenbergMarquardtTraining(BasicNetwork network, MLDataSet training) {
        super(TrainingImplementationType.Iterative);
        ValidateNetwork.validateMethodToData(network, training);
        if (network.getOutputCount() != 1) {
            throw new TrainingError("Levenberg Marquardt requires an output layer with a single neuron.");
        }
        this.setTraining(training);
        this.indexableTraining = this.getTraining();
        this.network = network;
        this.trainingLength = (int)this.indexableTraining.getRecordCount();
        this.parametersLength = this.network.getStructure().calculateSize();
        this.hessianMatrix = new Matrix(this.parametersLength, this.parametersLength);
        this.hessian = this.hessianMatrix.getData();
        this.beta = 1.0;
        this.lambda = 0.1;
        this.deltas = new double[this.parametersLength];
        this.gradient = new double[this.parametersLength];
        this.diagonal = new double[this.parametersLength];
        this.errors = new double[this.trainingLength];
        this.jacobian = new double[this.trainingLength][this.parametersLength];
        BasicMLData input = new BasicMLData(this.indexableTraining.getInputSize());
        BasicMLData ideal = new BasicMLData(this.indexableTraining.getIdealSize());
        this.pair = new BasicMLDataPair(input, ideal);
        this.differentialCoefficients = this.CreateCoefficients(3);
        this.derivativeStepSize = new double[this.parametersLength];
        for (int i = 0; i < this.parametersLength; ++i) {
            this.derivativeStepSize[i] = this.DERIV_STEP;
        }
    }

    public void calculateHessian() {
        int i;
        for (i = 0; i < this.parametersLength; ++i) {
            int j;
            double s = 0.0;
            for (j = 0; j < this.trainingLength; ++j) {
                s += this.jacobian[j][i] * this.errors[j];
            }
            this.gradient[i] = s;
            for (j = 0; j < this.parametersLength; ++j) {
                double c = 0.0;
                for (int k = 0; k < this.trainingLength; ++k) {
                    c += this.jacobian[k][i] * this.jacobian[k][j];
                }
                this.hessian[i][j] = this.beta * c;
            }
        }
        for (i = 0; i < this.parametersLength; ++i) {
            this.diagonal[i] = this.hessian[i][i];
        }
    }

    private double calculateSumOfSquaredWeights() {
        double result = 0.0;
        for (double weight : this.weights) {
            result += weight * weight;
        }
        return result / 2.0;
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    private double computeDerivative(MLData inputData, int layer, int neuron, int weight, double[] stepSize, double networkOutput, int jj) {
        int i;
        int numPoints = this.differentialCoefficients.length;
        double ret = 0.0;
        double originalValue = this.network.getWeight(layer, weight, neuron);
        double[] points = new double[numPoints];
        stepSize[jj] = originalValue != 0.0 ? this.DERIV_STEP * Math.abs(originalValue) : this.DERIV_STEP;
        int centerPoint = (numPoints - 1) / 2;
        for (i = 0; i < numPoints; ++i) {
            if (i != centerPoint) {
                double newValue = originalValue + (double)(i - centerPoint) * stepSize[jj];
                this.network.setWeight(layer, weight, neuron, newValue);
                MLData output = this.network.compute(inputData);
                points[i] = output.getData(0);
                continue;
            }
            points[i] = networkOutput;
        }
        ret = 0.0;
        for (i = 0; i < this.differentialCoefficients.length; ++i) {
            ret += this.differentialCoefficients[centerPoint][1][i] * points[i];
        }
        this.network.setWeight(layer, weight, neuron, originalValue);
        return ret /= Math.pow(stepSize[jj], 1.0);
    }

    private double[][][] CreateCoefficients(int points) {
        double[][][] coefficients = new double[points][points][points];
        for (int i = 0; i < points; ++i) {
            Matrix delts = new Matrix(points, points);
            double[][] ptr = delts.getData();
            for (int j = 0; j < points; ++j) {
                double delt = j - i;
                double hterm = 1.0;
                for (int k = 0; k < points; ++k) {
                    ptr[j][k] = hterm / EncogMath.factorial(k);
                    hterm *= delt;
                }
            }
            Matrix invMatrix = delts.inverse();
            double dNumPointsFactorial = EncogMath.factorial(points);
            for (int j = 0; j < points; ++j) {
                for (int k = 0; k < points; ++k) {
                    coefficients[i][j][k] = (double)Math.round(invMatrix.getData()[j][k] * dNumPointsFactorial) / dNumPointsFactorial;
                }
            }
        }
        return coefficients;
    }

    @Override
    public MLMethod getMethod() {
        return this.network;
    }

    @Override
    public void iteration() {
        LUDecomposition decomposition = null;
        this.preIteration();
        this.weights = NetworkCODEC.networkToArray(this.network);
        double sumOfSquaredErrors = this.jacobianByFiniteDifference();
        this.calculateHessian();
        double objective = this.beta * sumOfSquaredErrors;
        double current = objective + 1.0;
        this.lambda /= 10.0;
        while (current >= objective && this.lambda < 1.0E25) {
            int i;
            this.lambda *= 10.0;
            for (i = 0; i < this.parametersLength; ++i) {
                this.hessian[i][i] = this.diagonal[i] + this.lambda;
            }
            decomposition = new LUDecomposition(this.hessianMatrix);
            if (!decomposition.isNonsingular()) continue;
            this.deltas = decomposition.Solve(this.gradient);
            this.updateWeights();
            sumOfSquaredErrors = 0.0;
            for (i = 0; i < this.trainingLength; ++i) {
                this.indexableTraining.getRecord(i, this.pair);
                MLData actual = this.network.compute(this.pair.getInput());
                double e = this.pair.getIdeal().getData(0) - actual.getData(0);
                sumOfSquaredErrors += e * e;
            }
            current = this.beta * (sumOfSquaredErrors /= 2.0);
        }
        this.lambda /= 10.0;
        this.setError(sumOfSquaredErrors);
        this.postIteration();
    }

    private double jacobianByFiniteDifference() {
        double sumOfSquaredErrors = 0.0;
        this.getTraining().getRecordCount();
        int ji = 0;
        for (MLDataPair pair : this.getTraining()) {
            double e;
            MLData networkOutput = this.network.compute(pair.getInput());
            this.errors[ji] = e = pair.getIdeal().getData(0) - networkOutput.getData(0);
            sumOfSquaredErrors += e * e;
            int jj = 0;
            for (int layer = this.network.getLayerCount() - 1; layer > 0; --layer) {
                for (int neuron = 0; neuron < this.network.getLayerNeuronCount(layer); ++neuron) {
                    for (int weight = 0; weight < this.network.getLayerTotalNeuronCount(layer - 1); ++weight) {
                        this.jacobian[ji][jj] = this.computeDerivative(pair.getInput(), layer - 1, neuron, weight, this.derivativeStepSize, networkOutput.getData(0), jj);
                        ++jj;
                    }
                }
            }
            ++ji;
        }
        return sumOfSquaredErrors / 2.0;
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    public void updateWeights() {
        double[] w = (double[])this.weights.clone();
        for (int i = 0; i < w.length; ++i) {
            int n = i;
            w[n] = w[n] + this.deltas[i];
        }
        NetworkCODEC.arrayToNetwork(w, this.network);
    }
}

