/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som.training.clustercopy;

import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.neural.som.SOM;

public class SOMClusterCopyTraining
extends BasicTraining {
    private final SOM network;

    public SOMClusterCopyTraining(SOM network, MLDataSet training) {
        super(TrainingImplementationType.OnePass);
        this.network = network;
        this.setTraining(training);
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    private void copyInputPattern(int outputNeuron, MLData input) {
        for (int inputNeuron = 0; inputNeuron < this.network.getInputCount(); ++inputNeuron) {
            this.network.getWeights().set(inputNeuron, outputNeuron, input.getData(inputNeuron));
        }
    }

    @Override
    public final MLMethod getMethod() {
        return this.network;
    }

    @Override
    public final void iteration() {
        int outputNeuron = 0;
        for (MLDataPair pair : this.getTraining()) {
            this.copyInputPattern(outputNeuron++, pair.getInput());
        }
    }

    @Override
    public final TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

