/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.encog.EncogError;
import org.encog.util.logging.EncogLogging;

public final class Directory {
    public static final int BUFFER_SIZE = 1024;

    public static void copyFile(File source, File target) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            int packetSize = 0;
            while (packetSize != -1) {
                packetSize = in.read(buffer);
                if (packetSize == -1) continue;
                out.write(buffer, 0, packetSize);
            }
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
                in = null;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
                out = null;
            }
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File element : files = path.listFiles()) {
                if (element.isDirectory()) {
                    Directory.deleteDirectory(element);
                    continue;
                }
                if (element.delete()) continue;
                throw new EncogError("Failed to delete: " + element.toString() + "\nFile may be in use.");
            }
        }
        return path.delete();
    }

    public static String readStream(InputStream is) {
        BufferedReader reader = null;
        try {
            StringBuffer sb = new StringBuffer(1024);
            reader = new BufferedReader(new InputStreamReader(is));
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) > -1) {
                sb.append(new String(chars, 0, numRead));
            }
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
        }
    }

    public static String readTextFile(String filename) {
        try {
            StringBuffer sb = new StringBuffer(1024);
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) > -1) {
                sb.append(new String(chars, 0, numRead));
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    private Directory() {
    }
}

