/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.output.nominal;

import java.util.ArrayList;
import java.util.List;
import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.output.BasicOutputField;
import org.encog.util.normalize.output.nominal.NominalItem;

public class OutputOneOf
extends BasicOutputField {
    private final List<NominalItem> items = new ArrayList<NominalItem>();
    private double trueValue;
    private double falseValue;

    public OutputOneOf() {
        this(1.0, -1.0);
    }

    public OutputOneOf(double trueValue, double falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public void addItem(InputField inputField, double value) {
        this.addItem(inputField, value - 0.5, value + 0.5);
    }

    public void addItem(InputField inputField, double low, double high) {
        NominalItem item = new NominalItem(inputField, low, high);
        this.items.add(item);
    }

    @Override
    public double calculate(int subfield) {
        NominalItem item = this.items.get(subfield);
        return item.isInRange() ? this.trueValue : this.falseValue;
    }

    public double getFalseValue() {
        return this.falseValue;
    }

    @Override
    public int getSubfieldCount() {
        return this.items.size();
    }

    public double getTrueValue() {
        return this.trueValue;
    }

    @Override
    public void rowInit() {
    }
}

