/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.prop.PropertyConstraints;
import org.encog.app.analyst.script.prop.PropertyEntry;
import org.encog.app.analyst.script.segregate.AnalystSegregateTarget;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogReadHelper;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;

public class ScriptLoad {
    public static final int COLUMN_ONE = 1;
    public static final int COLUMN_TWO = 2;
    public static final int COLUMN_THREE = 3;
    public static final int COLUMN_FOUR = 4;
    public static final int COLUMN_FIVE = 5;
    private final AnalystScript script;

    public ScriptLoad(AnalystScript theScript) {
        this.script = theScript;
    }

    private void handleDataClasses(EncogFileSection section) {
        HashMap map = new HashMap();
        boolean first = true;
        for (String line : section.getLines()) {
            if (!first) {
                List<AnalystClassItem> classItems;
                List<String> cols = EncogFileSection.splitColumns(line);
                if (cols.size() < 4) {
                    throw new AnalystError("Invalid data class: " + line);
                }
                String string = cols.get(0);
                String code = cols.get(1);
                String name = cols.get(2);
                int count = Integer.parseInt(cols.get(3));
                DataField df = this.script.findDataField(string);
                if (df == null) {
                    throw new AnalystError("Attempting to add class to unknown field: " + name);
                }
                if (!map.containsKey(string)) {
                    classItems = new ArrayList();
                    map.put(string, classItems);
                } else {
                    classItems = (List)map.get(string);
                }
                classItems.add(new AnalystClassItem(code, name, count));
                continue;
            }
            first = false;
        }
        for (DataField dataField : this.script.getFields()) {
            List classList;
            if (!dataField.isClass() || (classList = (List)map.get(dataField.getName())) == null) continue;
            Collections.sort(classList);
            dataField.getClassMembers().clear();
            dataField.getClassMembers().addAll(classList);
        }
    }

    private void handleDataStats(EncogFileSection section) {
        ArrayList<DataField> dfs = new ArrayList<DataField>();
        boolean first = true;
        for (String line : section.getLines()) {
            if (!first) {
                List<String> cols = EncogFileSection.splitColumns(line);
                String name = cols.get(0);
                boolean isclass = Integer.parseInt(cols.get(1)) > 0;
                boolean iscomplete = Integer.parseInt(cols.get(2)) > 0;
                boolean isint = Integer.parseInt(cols.get(3)) > 0;
                boolean isreal = Integer.parseInt(cols.get(4)) > 0;
                double amax = CSVFormat.EG_FORMAT.parse(cols.get(5));
                double amin = CSVFormat.EG_FORMAT.parse(cols.get(6));
                double mean = CSVFormat.EG_FORMAT.parse(cols.get(7));
                double sdev = CSVFormat.EG_FORMAT.parse(cols.get(8));
                DataField df = new DataField(name);
                df.setClass(isclass);
                df.setComplete(iscomplete);
                df.setInteger(isint);
                df.setReal(isreal);
                df.setMax(amax);
                df.setMin(amin);
                df.setMean(mean);
                df.setStandardDeviation(sdev);
                dfs.add(df);
                continue;
            }
            first = false;
        }
        DataField[] array = new DataField[dfs.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (DataField)dfs.get(i);
        }
        this.script.setFields(array);
    }

    private void handleFilenames(EncogFileSection section) {
        Map<String, String> prop = section.parseParams();
        this.script.getProperties().clearFilenames();
        for (Map.Entry<String, String> e : prop.entrySet()) {
            this.script.getProperties().setFilename(e.getKey(), e.getValue());
        }
    }

    private void handleNormalizeRange(EncogFileSection section) {
        this.script.getNormalize().getNormalizedFields().clear();
        boolean first = true;
        for (String line : section.getLines()) {
            if (!first) {
                boolean isOutput;
                List<String> cols = EncogFileSection.splitColumns(line);
                String name = cols.get(0);
                String io = cols.get(1);
                int timeSlice = Integer.parseInt(cols.get(2));
                String action = cols.get(3);
                double high = CSVFormat.EG_FORMAT.parse(cols.get(4));
                double low = CSVFormat.EG_FORMAT.parse(cols.get(5));
                if (io.equalsIgnoreCase("input")) {
                    isOutput = false;
                } else if (io.equalsIgnoreCase("output")) {
                    isOutput = true;
                } else {
                    throw new AnalystError("Unknown io type:" + io);
                }
                NormalizationAction des = null;
                if (action.equals("range")) {
                    des = NormalizationAction.Normalize;
                } else if (action.equals("ignore")) {
                    des = NormalizationAction.Ignore;
                } else if (action.equals("pass")) {
                    des = NormalizationAction.PassThrough;
                } else if (action.equals("equilateral")) {
                    des = NormalizationAction.Equilateral;
                } else if (action.equals("single")) {
                    des = NormalizationAction.SingleField;
                } else if (action.equals("oneof")) {
                    des = NormalizationAction.OneOf;
                } else {
                    throw new AnalystError("Unknown field type:" + action);
                }
                AnalystField nf = new AnalystField(name, des, high, low);
                nf.setTimeSlice(timeSlice);
                nf.setOutput(isOutput);
                this.script.getNormalize().getNormalizedFields().add(nf);
                continue;
            }
            first = false;
        }
    }

    private void handleSegregateFiles(EncogFileSection section) {
        ArrayList<AnalystSegregateTarget> nfs = new ArrayList<AnalystSegregateTarget>();
        boolean first = true;
        for (String line : section.getLines()) {
            if (!first) {
                List<String> cols = EncogFileSection.splitColumns(line);
                String filename = cols.get(0);
                int percent = Integer.parseInt(cols.get(1));
                AnalystSegregateTarget nf = new AnalystSegregateTarget(filename, percent);
                nfs.add(nf);
                continue;
            }
            first = false;
        }
        AnalystSegregateTarget[] array = new AnalystSegregateTarget[nfs.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (AnalystSegregateTarget)nfs.get(i);
        }
        this.script.getSegregate().setSegregateTargets(array);
    }

    private void handleTask(EncogFileSection section) {
        AnalystTask task = new AnalystTask(section.getSubSectionName());
        for (String line : section.getLines()) {
            task.getLines().add(line);
        }
        this.script.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream stream) {
        EncogReadHelper reader = null;
        try {
            EncogFileSection section = null;
            reader = new EncogReadHelper(stream);
            while ((section = reader.readNextSection()) != null) {
                this.processSubSection(section);
            }
            this.script.init();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void loadSubSection(EncogFileSection section) {
        Map<String, String> prop = section.parseParams();
        for (String name : prop.keySet()) {
            String key = section.getSectionName().toUpperCase() + ":" + section.getSubSectionName().toUpperCase() + "_" + name;
            String value = prop.get(name);
            if (value == null) {
                value = "";
            }
            this.validateProperty(section.getSectionName(), section.getSubSectionName(), name, value);
            this.script.getProperties().setProperty(key, value);
        }
    }

    private void processSubSection(EncogFileSection section) {
        String currentSection = section.getSectionName();
        String currentSubsection = section.getSubSectionName();
        if (currentSection.equals("SETUP") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("SETUP") && currentSubsection.equalsIgnoreCase("FILENAMES")) {
            this.handleFilenames(section);
        } else if (currentSection.equals("DATA") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("DATA") && currentSubsection.equalsIgnoreCase("STATS")) {
            this.handleDataStats(section);
        } else if (currentSection.equals("DATA") && currentSubsection.equalsIgnoreCase("CLASSES")) {
            this.handleDataClasses(section);
        } else if (currentSection.equals("NORMALIZE") && currentSubsection.equalsIgnoreCase("RANGE")) {
            this.handleNormalizeRange(section);
        } else if (currentSection.equals("NORMALIZE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("NORMALIZE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("CLUSTER") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("SERIES") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("RANDOMIZE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("SEGREGATE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("SEGREGATE") && currentSubsection.equalsIgnoreCase("FILES")) {
            this.handleSegregateFiles(section);
        } else if (currentSection.equals("GENERATE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("HEADER") && currentSubsection.equalsIgnoreCase("DATASOURCE")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("ML") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("ML") && currentSubsection.equalsIgnoreCase("TRAIN")) {
            this.loadSubSection(section);
        } else if (currentSection.equals("TASKS") && currentSubsection.length() > 0) {
            this.handleTask(section);
        } else if (currentSection.equals("BALANCE") && currentSubsection.equalsIgnoreCase("CONFIG")) {
            this.loadSubSection(section);
        }
    }

    private void validateProperty(String section, String subSection, String name, String value) {
        PropertyEntry entry = PropertyConstraints.getInstance().getEntry(section, subSection, name);
        if (entry == null) {
            throw new AnalystError("Unknown property: " + PropertyEntry.dotForm(section, subSection, name));
        }
        entry.validate(section, subSection, name, value);
    }
}

