/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.encog.EncogError;
import org.encog.cloud.basic.CloudError;
import org.encog.cloud.basic.CloudPacket;

public class CommunicationLink {
    public final int SOCKET_TIMEOUT = 25000;
    private Socket socket;
    private ByteArrayOutputStream outputHolder;
    private DataOutputStream outputToRemote;
    private DataInputStream inputFromRemote;
    private OutputStream socketOut;

    public static String simpleHash(String str) {
        int result = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) {
                result += str.charAt(i) * (i * 10);
            }
            result %= 65535;
        }
        return Integer.toHexString(result).toLowerCase();
    }

    public CommunicationLink(Socket s) {
        try {
            this.socket = s;
            this.socket.setSoTimeout(25000);
            this.socketOut = this.socket.getOutputStream();
            this.outputHolder = new ByteArrayOutputStream();
            this.outputToRemote = new DataOutputStream(this.outputHolder);
            this.inputFromRemote = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException ex) {
            throw new CloudError(ex);
        }
    }

    public void writePacket(int command) {
        String[] args = new String[]{};
        this.writePacket(command, args);
    }

    public void writePacketLogin(String uid, String pwd) {
        String[] args = new String[]{uid, pwd};
        this.writePacket(1, args);
    }

    public void writePacket(int command, String[] args) {
        try {
            int length = 0;
            for (int i = 0; i < args.length; ++i) {
                length += args[i].length();
                ++length;
            }
            this.outputToRemote.writeByte(69);
            this.outputToRemote.writeByte(78);
            this.outputToRemote.writeByte(67);
            this.outputToRemote.writeByte(79);
            this.outputToRemote.writeByte(71);
            this.outputToRemote.writeByte(0);
            this.outputToRemote.writeByte(0);
            this.outputToRemote.writeByte(command);
            this.outputToRemote.writeByte(0);
            this.outputToRemote.writeLong(0L);
            this.outputToRemote.writeInt(length);
            byte[] b = new byte[length];
            int index = 0;
            for (int i = 0; i < args.length; ++i) {
                String str = args[i];
                for (int j = 0; j < str.length(); ++j) {
                    b[index++] = (byte)str.charAt(j);
                }
                b[index++] = 0;
            }
            this.outputToRemote.write(b);
            this.flushOutput();
        }
        catch (IOException ex) {
            throw new CloudError(ex);
        }
    }

    public CloudPacket readPacket() throws IOException {
        try {
            String[] args = null;
            if (this.inputFromRemote.readByte() != 69) {
                return null;
            }
            if (this.inputFromRemote.readByte() != 82) {
                return null;
            }
            if (this.inputFromRemote.readByte() != 84) {
                return null;
            }
            if (this.inputFromRemote.readByte() != 80) {
                return null;
            }
            byte version = this.inputFromRemote.readByte();
            byte command = this.inputFromRemote.readByte();
            byte count = this.inputFromRemote.readByte();
            long time = this.inputFromRemote.readLong();
            int size = this.inputFromRemote.readInt();
            if (size > 0) {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder builder = new StringBuilder();
                byte[] b = new byte[size];
                this.inputFromRemote.read(b);
                for (i = 0; i < b.length; ++i) {
                    if (b[i] == 0) {
                        list.add(builder.toString());
                        builder.setLength(0);
                        continue;
                    }
                    builder.append((char)b[i]);
                }
                args = new String[list.size()];
                for (i = 0; i < args.length; ++i) {
                    args[i] = (String)list.get(i);
                }
            }
            return new CloudPacket(command, args);
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
    }

    public void writeStatus(boolean s, String message) {
        String[] args = new String[]{s ? "1" : "0", message};
        this.writePacket(0, args);
    }

    public void writePacketIdentify(String name) {
        String[] args = new String[]{name};
        this.writePacket(3, args);
    }

    private void flushOutput() {
        try {
            this.socketOut.write(this.outputHolder.toByteArray());
            this.outputHolder.reset();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }
}

