/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;

public class ActivationSoftMax
implements ActivationFunction {
    private static final long serialVersionUID = -960489243250457611L;
    private final double[] params = new double[0];

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        int i;
        double sum = 0.0;
        for (i = start; i < start + size; ++i) {
            x[i] = BoundMath.exp(x[i]);
            sum += x[i];
        }
        for (i = start; i < start + size; ++i) {
            x[i] = x[i] / sum;
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationSoftMax();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        return 1.0;
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }
}

