/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.util.EngineArray;

public class RandomChoice {
    private final double[] probabilities;

    public RandomChoice(double[] theProbabilities) {
        block5: {
            double total;
            block4: {
                this.probabilities = EngineArray.arrayCopy(theProbabilities);
                total = 0.0;
                for (int i = 0; i < this.probabilities.length; ++i) {
                    total += this.probabilities[i];
                }
                if (total != 0.0) break block4;
                double prob = 1.0 / (double)this.probabilities.length;
                for (int i = 0; i < this.probabilities.length; ++i) {
                    this.probabilities[i] = prob;
                }
                break block5;
            }
            double total2 = 0.0;
            double factor = 1.0 / total;
            for (int i = 0; i < this.probabilities.length; ++i) {
                this.probabilities[i] = this.probabilities[i] * factor;
                total2 += this.probabilities[i];
            }
            if (!(Math.abs(1.0 - total2) > 0.02)) break block5;
            double prob = 1.0 / (double)this.probabilities.length;
            for (int i = 0; i < this.probabilities.length; ++i) {
                this.probabilities[i] = prob;
            }
        }
    }

    public static boolean generate(double p) {
        return Math.random() < p;
    }

    public int generate() {
        int i;
        double r = Math.random();
        double sum = 0.0;
        for (i = 0; i < this.probabilities.length; ++i) {
            if (!(r < (sum += this.probabilities[i]))) continue;
            return i;
        }
        for (i = 0; i < this.probabilities.length; ++i) {
            if (this.probabilities[i] == 0.0) continue;
            return i;
        }
        throw new EncogError("Invalid probabilities.");
    }

    public int generate(int skip) {
        int i;
        double totalProb = 1.0 - this.probabilities[skip];
        double throwValue = Math.random() * totalProb;
        double accumulator = 0.0;
        for (i = 0; i < skip; ++i) {
            if (!((accumulator += this.probabilities[i]) > throwValue)) continue;
            return i;
        }
        for (i = skip + 1; i < this.probabilities.length; ++i) {
            if (!((accumulator += this.probabilities[i]) > throwValue)) continue;
            return i;
        }
        for (i = 0; i < skip; ++i) {
            if (this.probabilities[i] == 0.0) continue;
            return i;
        }
        for (i = skip + 1; i < this.probabilities.length; ++i) {
            if (this.probabilities[i] == 0.0) continue;
            return i;
        }
        return -1;
    }
}

