/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.EventType;
import org.encog.ml.bayesian.query.BayesianQuery;
import org.encog.ml.bayesian.query.sample.EventState;

public abstract class BasicQuery
implements BayesianQuery,
Serializable {
    private final BayesianNetwork network;
    private final Map<BayesianEvent, EventState> events = new HashMap<BayesianEvent, EventState>();
    private final List<BayesianEvent> evidenceEvents = new ArrayList<BayesianEvent>();
    private final List<BayesianEvent> outcomeEvents = new ArrayList<BayesianEvent>();

    public BasicQuery() {
        this.network = null;
    }

    public BasicQuery(BayesianNetwork theNetwork) {
        this.network = theNetwork;
        this.finalizeStructure();
    }

    @Override
    public void finalizeStructure() {
        this.events.clear();
        for (BayesianEvent event : this.network.getEvents()) {
            this.events.put(event, new EventState(event));
        }
    }

    @Override
    public BayesianNetwork getNetwork() {
        return this.network;
    }

    @Override
    public Map<BayesianEvent, EventState> getEvents() {
        return this.events;
    }

    @Override
    public List<BayesianEvent> getEvidenceEvents() {
        return this.evidenceEvents;
    }

    @Override
    public List<BayesianEvent> getOutcomeEvents() {
        return this.outcomeEvents;
    }

    @Override
    public void locateEventTypes() {
        this.evidenceEvents.clear();
        this.outcomeEvents.clear();
        for (BayesianEvent event : this.network.getEvents()) {
            switch (this.getEventType(event)) {
                case Evidence: {
                    this.evidenceEvents.add(event);
                    break;
                }
                case Outcome: {
                    this.outcomeEvents.add(event);
                }
            }
        }
    }

    @Override
    public void reset() {
        for (EventState s : this.events.values()) {
            s.setCalculated(false);
        }
    }

    @Override
    public void defineEventType(BayesianEvent event, EventType et) {
        this.getEventState(event).setEventType(et);
    }

    @Override
    public EventState getEventState(BayesianEvent event) {
        return this.events.get(event);
    }

    @Override
    public EventType getEventType(BayesianEvent event) {
        return this.getEventState(event).getEventType();
    }

    protected boolean isNeededEvidence() {
        for (BayesianEvent evidenceEvent : this.evidenceEvents) {
            EventState state = this.getEventState(evidenceEvent);
            if (state.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    protected boolean satisfiesDesiredOutcome() {
        for (BayesianEvent outcomeEvent : this.outcomeEvents) {
            EventState state = this.getEventState(outcomeEvent);
            if (state.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEventValue(BayesianEvent event, boolean b) {
        this.setEventValue(event, b ? 0 : 1);
    }

    @Override
    public void setEventValue(BayesianEvent event, int d) {
        if (this.getEventType(event) == EventType.Hidden) {
            throw new BayesianError("You may only set the value of an evidence or outcome event.");
        }
        this.getEventState(event).setCompareValue(d);
        this.getEventState(event).setValue(d);
    }

    @Override
    public String getProblem() {
        if (this.outcomeEvents.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("P(");
        boolean first = true;
        for (BayesianEvent event : this.outcomeEvents) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(EventState.toSimpleString(this.getEventState(event)));
        }
        result.append("|");
        first = true;
        for (BayesianEvent event : this.evidenceEvents) {
            if (!first) {
                result.append(",");
            }
            first = false;
            EventState state = this.getEventState(event);
            if (state == null) break;
            result.append(EventState.toSimpleString(state));
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public BayesianQuery clone() {
        return null;
    }
}

