/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import java.io.Serializable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLDataCentroid;
import org.encog.util.kmeans.Centroid;

public class BasicMLData
implements MLData,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3644304891793584603L;
    private double[] data;

    public BasicMLData(double[] d) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BasicMLData(int size) {
        this.data = new double[size];
    }

    public BasicMLData(MLData d) {
        this(d.size());
        System.arraycopy(d.getData(), 0, this.data, 0, d.size());
    }

    @Override
    public final void add(int index, double value) {
        int n = index;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    @Override
    public final MLData clone() {
        return new BasicMLData(this);
    }

    @Override
    public final double[] getData() {
        return this.data;
    }

    @Override
    public final double getData(int index) {
        return this.data[index];
    }

    @Override
    public final void setData(double[] theData) {
        this.data = theData;
    }

    @Override
    public final void setData(int index, double d) {
        this.data[index] = d;
    }

    @Override
    public final int size() {
        return this.data.length;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.data[i]);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Centroid<MLData> createCentroid() {
        return new BasicMLDataCentroid(this);
    }

    public MLData plus(MLData o) {
        if (this.size() != o.size()) {
            throw new IllegalArgumentException();
        }
        BasicMLData result = new BasicMLData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setData(i, this.getData(i) + o.getData(i));
        }
        return result;
    }

    public MLData times(double d) {
        BasicMLData result = new BasicMLData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setData(i, this.getData(i) * d);
        }
        return result;
    }

    public MLData minus(MLData o) {
        if (this.size() != o.size()) {
            throw new IllegalArgumentException();
        }
        BasicMLData result = new BasicMLData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.setData(i, this.getData(i) - o.getData(i));
        }
        return result;
    }
}

