/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.folded;

import java.util.Iterator;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.folded.FoldedIterator;
import org.encog.neural.networks.training.TrainingError;

public class FoldedDataSet
implements MLDataSet {
    public static final String ADD_NOT_SUPPORTED = "Direct adds to the folded dataset are not supported.";
    private final MLDataSet underlying;
    private int currentFold;
    private int numFolds;
    private int foldSize;
    private int lastFoldSize;
    private int currentFoldOffset;
    private int currentFoldSize;
    private FoldedDataSet owner;

    public FoldedDataSet(MLDataSet theUnderlying) {
        this.underlying = theUnderlying;
        this.fold(1);
    }

    @Override
    public final void add(MLData data1) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public final void add(MLData inputData, MLData idealData) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public final void add(MLDataPair inputData) {
        throw new TrainingError(ADD_NOT_SUPPORTED);
    }

    @Override
    public final void close() {
        this.underlying.close();
    }

    public final void fold(int theNumFolds) {
        this.numFolds = (int)Math.min((long)theNumFolds, this.underlying.getRecordCount());
        this.foldSize = (int)(this.underlying.getRecordCount() / (long)this.numFolds);
        this.lastFoldSize = (int)(this.underlying.getRecordCount() - (long)(this.foldSize * this.numFolds));
        this.setCurrentFold(0);
    }

    public final int getCurrentFold() {
        if (this.owner != null) {
            return this.owner.getCurrentFold();
        }
        return this.currentFold;
    }

    public final int getCurrentFoldOffset() {
        if (this.owner != null) {
            return this.owner.getCurrentFoldOffset();
        }
        return this.currentFoldOffset;
    }

    public final int getCurrentFoldSize() {
        if (this.owner != null) {
            return this.owner.getCurrentFoldSize();
        }
        return this.currentFoldSize;
    }

    @Override
    public final int getIdealSize() {
        return this.underlying.getIdealSize();
    }

    @Override
    public final int getInputSize() {
        return this.underlying.getInputSize();
    }

    public final int getNumFolds() {
        return this.numFolds;
    }

    public final FoldedDataSet getOwner() {
        return this.owner;
    }

    @Override
    public final void getRecord(long index, MLDataPair pair) {
        this.underlying.getRecord((long)this.getCurrentFoldOffset() + index, pair);
    }

    @Override
    public final long getRecordCount() {
        return this.getCurrentFoldSize();
    }

    public final MLDataSet getUnderlying() {
        return this.underlying;
    }

    @Override
    public final boolean isSupervised() {
        return this.underlying.isSupervised();
    }

    @Override
    public final Iterator<MLDataPair> iterator() {
        return new FoldedIterator(this);
    }

    @Override
    public final MLDataSet openAdditional() {
        FoldedDataSet folded = new FoldedDataSet(this.underlying.openAdditional());
        folded.setOwner(this);
        return folded;
    }

    public final void setCurrentFold(int theCurrentFold) {
        if (this.owner != null) {
            throw new TrainingError("Can't set the fold on a non-top-level set.");
        }
        if (this.currentFold >= this.numFolds) {
            throw new TrainingError("Can't set the current fold to be greater than the number of folds.");
        }
        this.currentFold = theCurrentFold;
        this.currentFoldOffset = this.foldSize * this.currentFold;
        this.currentFoldSize = this.currentFold == this.numFolds - 1 ? this.lastFoldSize : this.foldSize;
    }

    public final void setOwner(FoldedDataSet theOwner) {
        this.owner = theOwner;
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        MLDataPair result = BasicMLDataPair.createPair(this.getInputSize(), this.getIdealSize());
        this.getRecord(index, result);
        return result;
    }
}

