/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.genome;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.ml.genetic.GeneticAlgorithm;
import org.encog.ml.genetic.GeneticError;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.population.Population;

public abstract class BasicGenome
implements Genome,
Serializable {
    private static final long serialVersionUID = 1L;
    private double adjustedScore;
    private double amountToSpawn;
    private final List<Chromosome> chromosomes = new ArrayList<Chromosome>();
    private transient GeneticAlgorithm geneticAlgorithm;
    private long genomeID;
    private transient Object organism;
    private double score = 0.0;
    private Population population;

    @Override
    public final int calculateGeneCount() {
        int result = 0;
        for (Chromosome chromosome : this.chromosomes) {
            result += chromosome.getGenes().size();
        }
        return result;
    }

    public boolean equals(Genome other) {
        return this.compareTo(other) == 0;
    }

    @Override
    public final int compareTo(Genome other) {
        if (this.geneticAlgorithm.getCalculateScore().shouldMinimize()) {
            return Double.compare(this.getScore(), other.getScore());
        }
        return Double.compare(other.getScore(), this.getScore());
    }

    @Override
    public final double getAdjustedScore() {
        return this.adjustedScore;
    }

    @Override
    public final double getAmountToSpawn() {
        return this.amountToSpawn;
    }

    @Override
    public final List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public final GeneticAlgorithm getGeneticAlgorithm() {
        return this.geneticAlgorithm;
    }

    @Override
    public final long getGenomeID() {
        return this.genomeID;
    }

    @Override
    public final Object getOrganism() {
        return this.organism;
    }

    @Override
    public final Population getPopulation() {
        return this.population;
    }

    @Override
    public final double getScore() {
        return this.score;
    }

    @Override
    public final void mate(Genome father, Genome child1, Genome child2) {
        int fatherChromosomes;
        int motherChromosomes = this.getChromosomes().size();
        if (motherChromosomes != (fatherChromosomes = father.getChromosomes().size())) {
            throw new GeneticError("Mother and father must have same chromosome count, Mother:" + motherChromosomes + ",Father:" + fatherChromosomes);
        }
        for (int i = 0; i < fatherChromosomes; ++i) {
            Chromosome motherChromosome = this.chromosomes.get(i);
            Chromosome fatherChromosome = father.getChromosomes().get(i);
            Chromosome offspring1Chromosome = child1.getChromosomes().get(i);
            Chromosome offspring2Chromosome = child2.getChromosomes().get(i);
            this.geneticAlgorithm.getCrossover().mate(motherChromosome, fatherChromosome, offspring1Chromosome, offspring2Chromosome);
            if (Math.random() < this.geneticAlgorithm.getMutationPercent()) {
                this.geneticAlgorithm.getMutate().performMutation(offspring1Chromosome);
            }
            if (!(Math.random() < this.geneticAlgorithm.getMutationPercent())) continue;
            this.geneticAlgorithm.getMutate().performMutation(offspring2Chromosome);
        }
        child1.decode();
        child2.decode();
        this.geneticAlgorithm.calculateScore(child1);
        this.geneticAlgorithm.calculateScore(child2);
    }

    @Override
    public final void setAdjustedScore(double theAdjustedScore) {
        this.adjustedScore = theAdjustedScore;
    }

    @Override
    public final void setAmountToSpawn(double theAmountToSpawn) {
        this.amountToSpawn = theAmountToSpawn;
    }

    @Override
    public final void setGeneticAlgorithm(GeneticAlgorithm ga) {
        this.geneticAlgorithm = ga;
    }

    @Override
    public final void setGenomeID(long theGenomeID) {
        this.genomeID = theGenomeID;
    }

    public final void setOrganism(Object theOrganism) {
        this.organism = theOrganism;
    }

    @Override
    public final void setPopulation(Population thePopulation) {
        this.population = thePopulation;
    }

    @Override
    public final void setScore(double theScore) {
        this.score = theScore;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(": score=");
        builder.append(this.getScore());
        return builder.toString();
    }
}

