/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.species;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.population.Population;
import org.encog.ml.genetic.species.Species;

public class BasicSpecies
implements Species,
Serializable {
    private static final long serialVersionUID = 1L;
    private int age;
    private double bestScore;
    private int gensNoImprovement;
    private Genome leader;
    private final List<Genome> members = new ArrayList<Genome>();
    private double spawnsRequired;
    private long speciesID;
    private Population population;
    private long leaderID;

    public BasicSpecies() {
    }

    public BasicSpecies(Population thePopulation, Genome theFirst, long theSpeciesID) {
        this.population = thePopulation;
        this.speciesID = theSpeciesID;
        this.bestScore = theFirst.getScore();
        this.gensNoImprovement = 0;
        this.age = 0;
        this.leader = theFirst;
        this.spawnsRequired = 0.0;
        this.members.add(theFirst);
    }

    @Override
    public final void calculateSpawnAmount() {
        this.spawnsRequired = 0.0;
        for (Genome genome : this.members) {
            this.spawnsRequired += genome.getAmountToSpawn();
        }
    }

    @Override
    public final Genome chooseParent() {
        Genome baby;
        if (this.members.size() == 1) {
            baby = this.members.get(0);
        } else {
            int maxIndexSize = (int)(this.population.getSurvivalRate() * (double)this.members.size()) + 1;
            int theOne = (int)RangeRandomizer.randomize(0.0, maxIndexSize);
            baby = this.members.get(theOne);
        }
        return baby;
    }

    @Override
    public final int getAge() {
        return this.age;
    }

    @Override
    public final double getBestScore() {
        return this.bestScore;
    }

    @Override
    public final int getGensNoImprovement() {
        return this.gensNoImprovement;
    }

    @Override
    public final Genome getLeader() {
        return this.leader;
    }

    @Override
    public final List<Genome> getMembers() {
        return this.members;
    }

    @Override
    public final double getNumToSpawn() {
        return this.spawnsRequired;
    }

    public final Population getPopulation() {
        return this.population;
    }

    @Override
    public final double getSpawnsRequired() {
        return this.spawnsRequired;
    }

    @Override
    public final long getSpeciesID() {
        return this.speciesID;
    }

    public final long getTempLeaderID() {
        return this.leaderID;
    }

    @Override
    public final void purge() {
        this.members.clear();
        ++this.age;
        ++this.gensNoImprovement;
        this.spawnsRequired = 0.0;
    }

    @Override
    public final void setAge(int theAge) {
        this.age = theAge;
    }

    @Override
    public final void setBestScore(double theBestScore) {
        this.bestScore = theBestScore;
    }

    @Override
    public final void setGensNoImprovement(int theGensNoImprovement) {
        this.gensNoImprovement = theGensNoImprovement;
    }

    @Override
    public final void setLeader(Genome theLeader) {
        this.leader = theLeader;
    }

    public final void setPopulation(Population thePopulation) {
        this.population = thePopulation;
    }

    @Override
    public final void setSpawnsRequired(double theSpawnsRequired) {
        this.spawnsRequired = theSpawnsRequired;
    }

    public final void setSpeciesID(int i) {
        this.speciesID = i;
    }

    public final void setTempLeaderID(long theLeaderID) {
        this.leaderID = theLeaderID;
    }
}

