/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.flat;

import java.io.Serializable;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.neural.flat.FlatLayer;
import org.encog.neural.flat.FlatNetwork;
import org.encog.util.EngineArray;

public class FlatNetworkRBF
extends FlatNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RadialBasisFunction[] rbf;

    public FlatNetworkRBF() {
    }

    public FlatNetworkRBF(int inputCount, int hiddenCount, int outputCount, RadialBasisFunction[] rbf) {
        FlatLayer[] layers = new FlatLayer[3];
        this.rbf = rbf;
        layers[0] = new FlatLayer(new ActivationLinear(), inputCount, 0.0);
        layers[1] = new FlatLayer(new ActivationLinear(), hiddenCount, 0.0);
        layers[2] = new FlatLayer(new ActivationLinear(), outputCount, 0.0);
        this.init(layers);
    }

    @Override
    public final FlatNetworkRBF clone() {
        FlatNetworkRBF result = new FlatNetworkRBF();
        this.cloneFlatNetwork(result);
        result.rbf = this.rbf;
        return result;
    }

    @Override
    public final void compute(double[] x, double[] output) {
        int outputIndex = this.getLayerIndex()[1];
        for (int i = 0; i < this.rbf.length; ++i) {
            double o;
            this.getLayerOutput()[outputIndex + i] = o = this.rbf[i].calculate(x);
        }
        this.computeLayer(1);
        EngineArray.arrayCopy(this.getLayerOutput(), 0, output, 0, this.getOutputCount());
    }

    public final void setRBF(RadialBasisFunction[] rbf) {
        this.rbf = new RadialBasisFunction[rbf.length];
        for (int i = 0; i < rbf.length; ++i) {
            this.rbf[i] = rbf[i];
        }
    }

    public final RadialBasisFunction[] getRBF() {
        return this.rbf;
    }
}

