/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSteepenedSigmoid;
import org.encog.ml.genetic.population.BasicPopulation;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovationList;

public class NEATPopulation
extends BasicPopulation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NEAT_ACTIVATION = "neatAct";
    int inputCount;
    int outputCount;
    private ActivationFunction neatActivationFunction = new ActivationSteepenedSigmoid();
    private int activationCycles = 4;

    public NEATPopulation(int inputCount, int outputCount, int populationSize) {
        super(populationSize);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        if (populationSize == 0) {
            throw new NeuralNetworkError("Population must have more than zero genomes.");
        }
        this.reset(populationSize);
    }

    public NEATPopulation() {
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public ActivationFunction getNeatActivationFunction() {
        return this.neatActivationFunction;
    }

    public void setNeatActivationFunction(ActivationFunction neatActivationFunction) {
        this.neatActivationFunction = neatActivationFunction;
    }

    public int getActivationCycles() {
        return this.activationCycles;
    }

    public void setActivationCycles(int activationCycles) {
        this.activationCycles = activationCycles;
    }

    public void reset(int populationSize) {
        this.getGenomes().clear();
        this.setPopulationSize(populationSize);
        this.getGeneIDGenerate().setCurrentID(1L);
        this.getGenomeIDGenerate().setCurrentID(1L);
        this.getInnovationIDGenerate().setCurrentID(1L);
        this.getSpeciesIDGenerate().setCurrentID(1L);
        for (int i = 0; i < populationSize; ++i) {
            NEATGenome genome = new NEATGenome(this.assignGenomeID(), this.inputCount, this.outputCount);
            this.add(genome);
        }
        NEATGenome genome = (NEATGenome)this.getGenomes().get(0);
        this.setInnovations(new NEATInnovationList(this, genome.getLinks(), genome.getNeurons()));
    }
}

