/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.neural.error.ErrorFunction;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.util.EngineArray;
import org.encog.util.concurrency.EngineTask;

public class GradientWorker
implements EngineTask {
    private final FlatNetwork network;
    private final ErrorCalculation errorCalculation = new ErrorCalculation();
    private final double[] actual;
    private final double[] layerDelta;
    private final int[] layerCounts;
    private final int[] layerFeedCounts;
    private final int[] layerIndex;
    private final int[] weightIndex;
    private final double[] layerOutput;
    private final double[] layerSums;
    private final double[] gradients;
    private final double[] weights;
    private final MLDataPair pair;
    private final MLDataSet training;
    private final int low;
    private final int high;
    private final Propagation owner;
    private double[] flatSpot;
    private final ErrorFunction errorFunction;

    public GradientWorker(FlatNetwork theNetwork, Propagation theOwner, MLDataSet theTraining, int theLow, int theHigh, double[] flatSpot, ErrorFunction ef) {
        this.network = theNetwork;
        this.training = theTraining;
        this.low = theLow;
        this.high = theHigh;
        this.owner = theOwner;
        this.flatSpot = flatSpot;
        this.errorFunction = ef;
        this.layerDelta = new double[this.network.getLayerOutput().length];
        this.gradients = new double[this.network.getWeights().length];
        this.actual = new double[this.network.getOutputCount()];
        this.weights = this.network.getWeights();
        this.layerIndex = this.network.getLayerIndex();
        this.layerCounts = this.network.getLayerCounts();
        this.weightIndex = this.network.getWeightIndex();
        this.layerOutput = this.network.getLayerOutput();
        this.layerSums = this.network.getLayerSums();
        this.layerFeedCounts = this.network.getLayerFeedCounts();
        this.pair = BasicMLDataPair.createPair(this.network.getInputCount(), this.network.getOutputCount());
    }

    public final FlatNetwork getNetwork() {
        return this.network;
    }

    public final double[] getWeights() {
        return this.weights;
    }

    private void process(double[] input, double[] ideal, double s) {
        int i;
        this.network.compute(input, this.actual);
        this.errorCalculation.updateError(this.actual, ideal, s);
        this.errorFunction.calculateError(ideal, this.actual, this.layerDelta);
        for (i = 0; i < this.actual.length; ++i) {
            this.layerDelta[i] = (this.network.getActivationFunctions()[0].derivativeFunction(this.layerSums[i], this.layerOutput[i]) + this.flatSpot[0]) * (this.layerDelta[i] * s);
        }
        for (i = this.network.getBeginTraining(); i < this.network.getEndTraining(); ++i) {
            this.processLevel(i);
        }
    }

    private void processLevel(int currentLevel) {
        int fromLayerIndex = this.layerIndex[currentLevel + 1];
        int toLayerIndex = this.layerIndex[currentLevel];
        int fromLayerSize = this.layerCounts[currentLevel + 1];
        int toLayerSize = this.layerFeedCounts[currentLevel];
        int index = this.weightIndex[currentLevel];
        ActivationFunction activation = this.network.getActivationFunctions()[currentLevel + 1];
        double currentFlatSpot = this.flatSpot[currentLevel + 1];
        int yi = fromLayerIndex;
        for (int y = 0; y < fromLayerSize; ++y) {
            double output = this.layerOutput[yi];
            double sum = 0.0;
            int xi = toLayerIndex;
            int wi = index + y;
            for (int x = 0; x < toLayerSize; ++x) {
                int n = wi;
                this.gradients[n] = this.gradients[n] + output * this.layerDelta[xi];
                sum += this.weights[wi] * this.layerDelta[xi];
                wi += fromLayerSize;
                ++xi;
            }
            this.layerDelta[yi] = sum * (activation.derivativeFunction(this.layerSums[yi], this.layerOutput[yi]) + currentFlatSpot);
            ++yi;
        }
    }

    @Override
    public final void run() {
        try {
            this.errorCalculation.reset();
            for (int i = this.low; i <= this.high; ++i) {
                this.training.getRecord(i, this.pair);
                this.process(this.pair.getInputArray(), this.pair.getIdealArray(), this.pair.getSignificance());
            }
            double error = this.errorCalculation.calculate();
            this.owner.report(this.gradients, error, null);
            EngineArray.fill(this.gradients, 0.0);
        }
        catch (Throwable ex) {
            this.owner.report(null, 0.0, ex);
        }
    }
}

