/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.manhattan;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class ManhattanPropagation
extends Propagation
implements LearningRate {
    static final double DEFAULT_ZERO_TOLERANCE = 0.001;
    private final double zeroTolerance;
    private double learningRate;

    public ManhattanPropagation(ContainsFlat network, MLDataSet training, double theLearnRate) {
        super(network, training);
        this.learningRate = theLearnRate;
        this.zeroTolerance = 1.0E-17;
    }

    @Override
    public final double getLearningRate() {
        return this.learningRate;
    }

    @Override
    public final void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    @Override
    public final TrainingContinuation pause() {
        return null;
    }

    @Override
    public final void resume(TrainingContinuation state) {
    }

    @Override
    public final double updateWeight(double[] gradients, double[] lastGradient, int index) {
        if (Math.abs(gradients[index]) < this.zeroTolerance) {
            return 0.0;
        }
        if (gradients[index] > 0.0) {
            return this.learningRate;
        }
        return -this.learningRate;
    }

    @Override
    public void initOthers() {
    }
}

