/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.encog.persist.EncogFileSection;
import org.encog.persist.PersistError;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class EncogReadHelper {
    private final BufferedReader reader;
    private final List<String> lines = new ArrayList<String>();
    private String currentSectionName = "";
    private String currentSubSectionName = "";
    private EncogFileSection section;

    public EncogReadHelper(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public final void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new PersistError(e);
        }
    }

    public final EncogFileSection readNextSection() {
        try {
            String line;
            ArrayList<double[]> largeArrays = new ArrayList<double[]>();
            while ((line = this.reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("//")) continue;
                if (line.startsWith("[")) {
                    this.section = new EncogFileSection(this.currentSectionName, this.currentSubSectionName);
                    this.section.getLines().addAll(this.lines);
                    this.lines.clear();
                    String s = line.substring(1).trim();
                    if (!s.endsWith("]")) {
                        throw new PersistError("Invalid section: " + line);
                    }
                    int idx = (s = s.substring(0, line.length() - 2)).indexOf(58);
                    if (idx == -1) {
                        this.currentSectionName = s;
                        this.currentSubSectionName = "";
                    } else {
                        if (this.currentSectionName.length() < 1) {
                            throw new PersistError("Can't begin subsection when a section has not yet been defined: " + line);
                        }
                        String newSection = s.substring(0, idx);
                        String newSubSection = s.substring(idx + 1);
                        if (!newSection.equals(this.currentSectionName)) {
                            throw new PersistError("Can't begin subsection " + line + ", while we are still in the section: " + this.currentSectionName);
                        }
                        this.currentSubSectionName = newSubSection;
                    }
                    this.section.setLargeArrays(largeArrays);
                    return this.section;
                }
                if (line.length() < 1) continue;
                if (line.startsWith("##double")) {
                    double[] d = this.readLargeArray(line);
                    largeArrays.add(d);
                    continue;
                }
                if (this.currentSectionName.length() < 1) {
                    throw new PersistError("Unknown command before first section: " + line);
                }
                this.lines.add(line);
            }
            if (this.currentSectionName.length() == 0) {
                return null;
            }
            this.section = new EncogFileSection(this.currentSectionName, this.currentSubSectionName);
            this.section.getLines().addAll(this.lines);
            this.currentSectionName = "";
            this.currentSubSectionName = "";
            this.section.setLargeArrays(largeArrays);
            return this.section;
        }
        catch (IOException ex) {
            throw new PersistError(ex);
        }
    }

    private double[] readLargeArray(String line) throws IOException {
        String str = line.substring(9);
        int l = Integer.parseInt(str);
        double[] result = new double[l];
        int index = 0;
        while ((line = this.reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("//")) continue;
            if (line.startsWith("##end")) break;
            double[] t = NumberList.fromList(CSVFormat.EG_FORMAT, line);
            EngineArray.arrayCopy(t, 0, result, index, t.length);
            index += t.length;
        }
        return result;
    }
}

