/*
 * Encog(tm) Core v3.1 - Java Version
 * http://www.heatonresearch.com/encog/
 * http://code.google.com/p/encog-java/
 
 * Copyright 2008-2012 Heaton Research, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *   
 * For more information on Heaton Research copyrights, licenses 
 * and trademarks visit:
 * http://www.heatonresearch.com/copyright
 */
package org.encog.neural.networks;

import junit.framework.TestCase;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.junit.Assert;

public class TestLimited extends TestCase {
	
	public void testLimited()
	{
		MLDataSet trainingData = new BasicMLDataSet(XOR.XOR_INPUT,XOR.XOR_IDEAL);
		BasicNetwork network = NetworkUtil.createXORNetworkUntrained();		
		
		ResilientPropagation rprop = new ResilientPropagation(network,trainingData);
		rprop.iteration();
		rprop.iteration();
		network.enableConnection(1, 0, 0, false);
		network.enableConnection(1, 1, 0, false);
		
		Assert.assertTrue(network.getStructure().isConnectionLimited());
		
		Assert.assertEquals(0.0, network.getStructure().getFlat().getWeights()[0], 0.01);
		Assert.assertEquals(0.0, network.getStructure().getFlat().getWeights()[1], 0.01);
		rprop.iteration();
		rprop.iteration();
		rprop.iteration();
		rprop.iteration();
		// these connections were removed, and should not have been "trained"
		Assert.assertEquals(0.0, network.getStructure().getFlat().getWeights()[0], 0.01);
		Assert.assertEquals(0.0, network.getStructure().getFlat().getWeights()[1], 0.01);		
		rprop.finishTraining();
	}
}
