/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.analyze;

import java.util.List;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.analyze.AnalyzedField;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.analyst.util.ConvertStringConst;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class PerformAnalysis {
    private final String filename;
    private final boolean headers;
    private final AnalystFileFormat format;
    private AnalyzedField[] fields;
    private final AnalystScript script;

    public PerformAnalysis(AnalystScript theScript, String theFilename, boolean theHeaders, AnalystFileFormat theFormat) {
        this.filename = theFilename;
        this.headers = theHeaders;
        this.format = theFormat;
        this.script = theScript;
    }

    private void generateFields(ReadCSV csv) {
        if (this.headers) {
            this.generateFieldsFromHeaders(csv);
        } else {
            this.generateFieldsFromCount(csv);
        }
    }

    private void generateFieldsFromCount(ReadCSV csv) {
        this.fields = new AnalyzedField[csv.getColumnCount()];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new AnalyzedField(this.script, "field:" + (i + 1));
        }
    }

    private void generateFieldsFromHeaders(ReadCSV csv) {
        CSVHeaders h = new CSVHeaders(csv.getColumnNames());
        this.fields = new AnalyzedField[csv.getColumnCount()];
        for (int i = 0; i < this.fields.length; ++i) {
            if (i >= csv.getColumnNames().size()) {
                throw new AnalystError("CSV header count does not match column count");
            }
            this.fields[i] = new AnalyzedField(this.script, h.getHeader(i));
        }
    }

    public final void process(EncogAnalyst target) {
        int count = 0;
        CSVFormat csvFormat = ConvertStringConst.convertToCSVFormat(this.format);
        ReadCSV csv = new ReadCSV(this.filename, this.headers, csvFormat);
        while (csv.next()) {
            if (this.fields == null) {
                this.generateFields(csv);
            }
            for (int i = 0; i < csv.getColumnCount(); ++i) {
                this.fields[i].analyze1(csv.get(i));
            }
            ++count;
        }
        if (count == 0) {
            throw new AnalystError("Can't analyze file, it is empty.");
        }
        for (AnalyzedField field : this.fields) {
            field.completePass1();
        }
        csv.close();
        csv = new ReadCSV(this.filename, this.headers, csvFormat);
        while (csv.next()) {
            for (int i = 0; i < csv.getColumnCount(); ++i) {
                this.fields[i].analyze2(csv.get(i));
            }
        }
        for (AnalyzedField field : this.fields) {
            field.completePass2();
        }
        csv.close();
        String str = this.script.getProperties().getPropertyString("SETUP:CONFIG_allowedClasses");
        if (str == null) {
            str = "";
        }
        boolean allowInt = str.contains("int");
        boolean allowReal = str.contains("real") || str.contains("double");
        boolean allowString = str.contains("string");
        for (AnalyzedField field : this.fields) {
            if (!field.isClass()) continue;
            if (!allowInt && field.isInteger()) {
                field.setClass(false);
            }
            if (!(allowString || field.isInteger() || field.isReal())) {
                field.setClass(false);
            }
            if (allowReal || !field.isReal() || field.isInteger()) continue;
            field.setClass(false);
        }
        if (target.getScript().getFields() != null && this.fields.length == target.getScript().getFields().length) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].setName(target.getScript().getFields()[i].getName());
                if (!this.fields[i].isClass()) continue;
                List<AnalystClassItem> t = this.fields[i].getAnalyzedClassMembers();
                List<AnalystClassItem> s = target.getScript().getFields()[i].getClassMembers();
                if (s.size() != t.size()) continue;
                for (int j = 0; j < s.size(); ++j) {
                    if (!t.get(j).getCode().equals(s.get(j).getCode())) continue;
                    t.get(j).setName(s.get(j).getName());
                }
            }
        }
        DataField[] df = new DataField[this.fields.length];
        for (int i = 0; i < df.length; ++i) {
            df[i] = this.fields[i].finalizeField();
        }
        target.getScript().setFields(df);
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" filename=");
        result.append(this.filename);
        result.append(", headers=");
        result.append(this.headers);
        result.append("]");
        return result.toString();
    }
}

