/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.ml.MLMethod;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.data.buffer.EncogEGBFile;
import org.encog.ml.factory.MLMethodFactory;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.logging.EncogLogging;

public class CmdCreate
extends Cmd {
    public static final String COMMAND_NAME = "CREATE";

    public CmdCreate(EncogAnalyst theAnalyst) {
        super(theAnalyst);
    }

    @Override
    public final boolean executeCommand(String args) {
        String trainingID = this.getProp().getPropertyString("ML:CONFIG_trainingFile");
        String resourceID = this.getProp().getPropertyString("ML:CONFIG_machineLearningFile");
        File trainingFile = this.getScript().resolveFilename(trainingID);
        File resourceFile = this.getScript().resolveFilename(resourceID);
        String type = this.getProp().getPropertyString("ML:CONFIG_type");
        String arch = this.getProp().getPropertyString("ML:CONFIG_architecture");
        EncogLogging.log(0, "Beginning create");
        EncogLogging.log(0, "training file:" + trainingID);
        EncogLogging.log(0, "resource file:" + resourceID);
        EncogLogging.log(0, "type:" + type);
        EncogLogging.log(0, "arch:" + arch);
        EncogEGBFile egb = new EncogEGBFile(trainingFile);
        egb.open();
        int input = egb.getInputCount();
        int ideal = egb.getIdealCount();
        egb.close();
        MLMethodFactory factory = new MLMethodFactory();
        MLMethod obj = factory.create(type, arch, input, ideal);
        if (obj instanceof BayesianNetwork) {
            String query = this.getProp().getPropertyString("ML:CONFIG_query");
            ((BayesianNetwork)obj).defineClassificationStructure(query);
        }
        EncogDirectoryPersistence.saveObject(resourceFile, (Object)obj);
        return false;
    }

    @Override
    public final String getName() {
        return COMMAND_NAME;
    }
}

