/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.AnalystEvaluateRawCSV;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.logging.EncogLogging;

public class CmdEvaluateRaw
extends Cmd {
    public static final String COMMAND_NAME = "EVALUATE-RAW";

    public CmdEvaluateRaw(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public final boolean executeCommand(String args) {
        String evalID = this.getProp().getPropertyString("ML:CONFIG_evalFile");
        String resourceID = this.getProp().getPropertyString("ML:CONFIG_machineLearningFile");
        String outputID = this.getProp().getPropertyString("ML:CONFIG_outputFile");
        EncogLogging.log(0, "Beginning evaluate raw");
        EncogLogging.log(0, "evaluate file:" + evalID);
        EncogLogging.log(0, "resource file:" + resourceID);
        File evalFile = this.getScript().resolveFilename(evalID);
        File resourceFile = this.getScript().resolveFilename(resourceID);
        File outputFile = this.getAnalyst().getScript().resolveFilename(outputID);
        MLMethod m = (MLMethod)EncogDirectoryPersistence.loadObject(resourceFile);
        if (!(m instanceof MLRegression)) {
            throw new AnalystError("The evaluate raw command can only be used with regression.");
        }
        MLRegression method = (MLRegression)m;
        boolean headers = this.getScript().expectInputHeaders(evalID);
        AnalystEvaluateRawCSV eval = new AnalystEvaluateRawCSV();
        eval.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(eval);
        eval.setReport(new AnalystReportBridge(this.getAnalyst()));
        eval.analyze(this.getAnalyst(), evalFile, headers, this.getProp().getPropertyCSVFormat("SETUP:CONFIG_csvFormat"));
        eval.process(outputFile, method);
        this.getAnalyst().setCurrentQuantTask(null);
        return eval.shouldStop();
    }

    @Override
    public final String getName() {
        return COMMAND_NAME;
    }
}

