/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.quant.QuantError;
import org.encog.ml.MLCluster;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.kmeans.KMeansClustering;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class AnalystClusterCSV
extends BasicFile {
    private EncogAnalyst analyst;
    private CSVHeaders analystHeaders;
    private BasicMLDataSet data;

    public final void analyze(EncogAnalyst theAnalyst, File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.analyst = theAnalyst;
        this.data = new BasicMLDataSet();
        this.resetStatus();
        int recordCount = 0;
        int outputLength = this.analyst.determineTotalColumns();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        this.readHeaders(csv);
        this.analystHeaders = new CSVHeaders(this.getInputHeadings());
        while (csv.next() && !this.shouldStop()) {
            this.updateStatus(true);
            double[] inputArray = AnalystNormalizeCSV.extractFields(this.analyst, this.analystHeaders, csv, outputLength, true);
            BasicMLData input = new BasicMLData(inputArray);
            this.data.add(new BasicMLDataPair(input));
            ++recordCount;
        }
        this.setRecordCount(recordCount);
        this.setColumnCount(csv.getColumnCount());
        this.readHeaders(csv);
        csv.close();
        this.reportDone(true);
    }

    private PrintWriter prepareOutputFile(File outputFile, int input, int output) {
        try {
            PrintWriter tw = new PrintWriter(new FileWriter(outputFile));
            if (this.isProduceOutputHeaders()) {
                StringBuilder line = new StringBuilder();
                for (String heading : this.getInputHeadings()) {
                    BasicFile.appendSeparator(line, this.getFormat());
                    line.append("\"");
                    line.append(heading);
                    line.append("\"");
                }
                BasicFile.appendSeparator(line, this.getFormat());
                line.append("\"cluster\"");
                tw.println(line.toString());
            }
            return tw;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    public final void process(File outputFile, int clusters, EncogAnalyst theAnalyst, int iterations) {
        PrintWriter tw = this.prepareOutputFile(outputFile, this.analyst.getScript().getNormalize().countActiveFields() - 1, 1);
        this.resetStatus();
        KMeansClustering cluster = new KMeansClustering(clusters, this.data);
        cluster.iteration(iterations);
        int clusterNum = 0;
        for (MLCluster cl : cluster.getClusters()) {
            for (MLData item : cl.getData()) {
                int clsIndex = item.size();
                LoadedRow lr = new LoadedRow(this.getFormat(), item.getData(), 1);
                lr.getData()[clsIndex] = "" + clusterNum;
                this.writeRow(tw, lr);
            }
            ++clusterNum;
        }
        this.reportDone(false);
        tw.close();
    }
}

