/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.normalize;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.EncogError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.TimeSeriesUtil;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.missing.HandleMissingValues;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.quant.QuantError;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public class AnalystNormalizeCSV
extends BasicFile {
    private EncogAnalyst analyst;
    private TimeSeriesUtil series;
    private CSVHeaders analystHeaders;

    public static final double[] extractFields(EncogAnalyst analyst, CSVHeaders headers, ReadCSV csv, int outputLength, boolean skipOutput) {
        double[] output = new double[outputLength];
        int outputIndex = 0;
        for (AnalystField stat : analyst.getScript().getNormalize().getNormalizedFields()) {
            double[] d;
            stat.init();
            if (stat.getAction() == NormalizationAction.Ignore || stat.isOutput() && skipOutput) continue;
            int index = headers.find(stat.getName());
            String str = csv.get(index).trim();
            if (str.equals("?") || str.length() == 0) {
                HandleMissingValues handler = analyst.getScript().getNormalize().getMissingValues();
                double[] d2 = handler.handleMissing(analyst, stat);
                if (d2 == null) {
                    return null;
                }
                for (int i = 0; i < d2.length; ++i) {
                    output[outputIndex++] = d2[i];
                }
                continue;
            }
            if (stat.getAction() == NormalizationAction.Normalize) {
                double d3 = csv.getFormat().parse(str);
                d3 = stat.normalize(d3);
                output[outputIndex++] = d3;
                continue;
            }
            if (stat.getAction() == NormalizationAction.PassThrough) {
                double d4 = csv.getFormat().parse(str);
                output[outputIndex++] = d4;
                continue;
            }
            for (double element : d = stat.encode(str)) {
                output[outputIndex++] = element;
            }
        }
        return output;
    }

    public final void analyze(File inputFilename, boolean expectInputHeaders, CSVFormat inputFormat, EncogAnalyst theAnalyst) {
        this.setInputFilename(inputFilename);
        this.setInputFormat(inputFormat);
        this.setExpectInputHeaders(expectInputHeaders);
        this.analyst = theAnalyst;
        this.setAnalyzed(true);
        this.analystHeaders = new CSVHeaders(inputFilename, expectInputHeaders, inputFormat);
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            field.init();
        }
        this.series = new TimeSeriesUtil(this.analyst, true, this.analystHeaders.getHeaders());
    }

    public final void normalize(File file) {
        if (this.analyst == null) {
            throw new EncogError("Can't normalize yet, file has not been analyzed.");
        }
        ReadCSV csv = null;
        PrintWriter tw = null;
        try {
            csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
            tw = new PrintWriter(new FileWriter(file));
            if (this.isProduceOutputHeaders()) {
                this.writeHeaders(tw);
            }
            this.resetStatus();
            int outputLength = this.analyst.determineTotalColumns();
            while (csv.next() && !this.shouldStop()) {
                this.updateStatus(false);
                double[] output = AnalystNormalizeCSV.extractFields(this.analyst, this.analystHeaders, csv, outputLength, false);
                if (this.series.getTotalDepth() > 1) {
                    output = this.series.process(output);
                }
                if (output == null) continue;
                StringBuilder line = new StringBuilder();
                NumberList.toList(this.getFormat(), line, output);
                tw.println(line);
            }
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
        finally {
            this.reportDone(false);
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
            if (tw != null) {
                try {
                    tw.close();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
        }
    }

    public final void setSourceFile(File file, boolean headers, CSVFormat format) {
        this.setInputFilename(file);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
    }

    private void writeHeaders(PrintWriter tw) {
        StringBuilder line = new StringBuilder();
        for (AnalystField stat : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            int needed = stat.getColumnsNeeded();
            for (int i = 0; i < needed; ++i) {
                BasicFile.appendSeparator(line, this.getFormat());
                line.append('\"');
                line.append(CSVHeaders.tagColumn(stat.getName(), i, stat.getTimeSlice(), needed > 1));
                line.append('\"');
            }
        }
        tw.println(line.toString());
    }
}

