/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.segregate;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.segregate.SegregateTargetPercent;
import org.encog.app.quant.QuantError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class SegregateCSV
extends BasicFile {
    public static final int TOTAL_PCT = 100;
    private final List<SegregateTargetPercent> targets = new ArrayList<SegregateTargetPercent>();

    public final void analyze(File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.performBasicCounts();
        this.balanceTargets();
    }

    private void balanceTargets() {
        SegregateTargetPercent smallestItem = null;
        int numberAssigned = 0;
        Iterator<SegregateTargetPercent> i$ = this.targets.iterator();
        while (i$.hasNext()) {
            SegregateTargetPercent p;
            SegregateTargetPercent stp = p = i$.next();
            double percent = (double)stp.getPercent() / 100.0;
            int c = (int)((double)this.getRecordCount() * percent);
            stp.setNumberRemaining(c);
            if (smallestItem == null || smallestItem.getPercent() > stp.getPercent()) {
                smallestItem = stp;
            }
            numberAssigned += c;
        }
        int remain = this.getRecordCount() - numberAssigned;
        if (remain > 0) {
            smallestItem.setNumberRemaining(smallestItem.getNumberRemaining() + remain);
        }
    }

    public final List<SegregateTargetPercent> getTargets() {
        return this.targets;
    }

    public final void process() {
        this.validate();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        this.resetStatus();
        for (SegregateTargetPercent target : this.targets) {
            PrintWriter tw = this.prepareOutputFile(target.getFilename());
            while (target.getNumberRemaining() > 0 && csv.next() && !this.shouldStop()) {
                this.updateStatus(false);
                LoadedRow row = new LoadedRow(csv);
                this.writeRow(tw, row);
                target.setNumberRemaining(target.getNumberRemaining() - 1);
            }
            tw.close();
        }
        this.reportDone(false);
        csv.close();
    }

    private void validate() {
        this.validateAnalyzed();
        if (this.targets.size() < 1) {
            throw new QuantError("There are no segregation targets.");
        }
        if (this.targets.size() < 2) {
            throw new QuantError("There must be at least two segregation targets.");
        }
        int total = 0;
        for (SegregateTargetPercent p : this.targets) {
            total += p.getPercent();
        }
        if (total != 100) {
            throw new QuantError("Target percents must equal 100.");
        }
    }
}

