/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud.node;

import java.io.IOException;
import org.encog.cloud.basic.CloudPacket;
import org.encog.cloud.basic.CommunicationLink;
import org.encog.cloud.node.CloudNode;

public class HandleClient
implements Runnable {
    private CommunicationLink link;
    private boolean done;
    private CloudNode server;
    private String userID;

    public HandleClient(CloudNode s, CommunicationLink l) {
        this.link = l;
        this.server = s;
    }

    private void handleLogin(CloudPacket packet) {
        String uid = packet.getArgs()[0];
        String pwd = packet.getArgs()[1];
        System.out.println("UID:" + uid);
        System.out.println("PWD:" + pwd);
        boolean success = false;
        if (this.server.getAccounts().size() == 0) {
            success = true;
        } else if (!this.server.getAccounts().containsKey(uid.toLowerCase())) {
            success = false;
        } else {
            String p = this.server.getAccounts().get(uid.toLowerCase());
            success = p.equals(pwd);
        }
        if (success) {
            this.userID = uid;
            this.link.writeStatus(true, "");
        } else {
            this.userID = null;
            this.link.writeStatus(false, "Login failure.");
        }
    }

    private void handleIdentify() {
        this.link.writeStatus(true, "");
    }

    private void handleLogout() {
        this.link.writeStatus(true, "");
        this.done = true;
        System.out.println("Logging out client");
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                System.out.println("Waiting for packets");
                CloudPacket packet = this.link.readPacket();
                if (packet == null) continue;
                if (packet != null) {
                    switch (packet.getCommand()) {
                        case 1: {
                            this.handleLogin(packet);
                            break;
                        }
                        case 2: {
                            this.handleLogout();
                            break;
                        }
                        case 3: {
                            this.handleIdentify();
                        }
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
            catch (IOException ex) {
                System.out.println("Client ended connection.");
                return;
            }
        }
        System.out.println("Shutting down client handler");
    }
}

