/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationElliott
implements ActivationFunction {
    private static final long serialVersionUID = 1234L;
    private final double[] params = new double[1];

    public ActivationElliott() {
        this.params[0] = 1.0;
    }

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            double s = this.params[0];
            x[i] = x[i] * s / 2.0 / (1.0 + Math.abs(x[i] * s)) + 0.5;
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationElliott();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        double s = this.params[0];
        return s / (2.0 * (1.0 + Math.abs(b * s)) * (1.0 + Math.abs(b * s)));
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{"Slope"};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }
}

