/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.BoundMath;

public class ActivationGaussian
implements ActivationFunction {
    public static final int PARAM_GAUSSIAN_CENTER = 0;
    public static final int PARAM_GAUSSIAN_WIDTH = 1;
    private double[] params = new double[2];
    private static final long serialVersionUID = -7166136514935838114L;

    public ActivationGaussian(double center, double width) {
        this.params[0] = center;
        this.params[1] = width;
    }

    public ActivationGaussian() {
        this.params[0] = 0.1;
        this.params[0] = 0.1;
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationGaussian(this.getCenter(), this.getWidth());
    }

    public final double getWidth() {
        return this.getParams()[1];
    }

    public final double getCenter() {
        return this.getParams()[0];
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            double d = (x[i] - this.params[0]) * Math.sqrt(this.params[1]) * 4.0;
            x[i] = BoundMath.exp(-(d * d));
        }
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        return -(Math.exp(-Math.pow((b - this.params[0]) * Math.sqrt(this.params[1]) * 4.0, 2.0)) * (2.0 * (Math.sqrt(this.params[1]) * 4.0 * ((b - this.params[0]) * Math.sqrt(this.params[1]) * 4.0))));
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{"center", "width"};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }
}

