/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

import java.util.Random;

public class VectorAlgebra {
    static Random rand = new Random();

    public void add(double[] v1, double[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] + v2[i];
        }
    }

    public void sub(double[] v1, double[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] - v2[i];
        }
    }

    public void neg(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = -v[i];
        }
    }

    public void mulRand(double[] v, double k) {
        int i = 0;
        while (i < v.length) {
            int n = i++;
            v[n] = v[n] * (k * rand.nextDouble());
        }
    }

    public void mul(double[] v, double k) {
        int i = 0;
        while (i < v.length) {
            int n = i++;
            v[n] = v[n] * k;
        }
    }

    public void copy(double[] dst, double[] src) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public void randomise(double[] v) {
        this.randomise(v, 0.1);
    }

    public void randomise(double[] v, double maxValue) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = (2.0 * rand.nextDouble() - 1.0) * maxValue;
        }
    }

    public void clampComponents(double[] v, double maxValue) {
        if (maxValue != -1.0) {
            for (int i = 0; i < v.length; ++i) {
                if (v[i] > maxValue) {
                    v[i] = maxValue;
                }
                if (!(v[i] < -maxValue)) continue;
                v[i] = -maxValue;
            }
        }
    }
}

