/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.hessian;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.neural.flat.FlatNetwork;
import org.encog.util.EngineArray;
import org.encog.util.concurrency.EngineTask;

public class ChainRuleWorker
implements EngineTask {
    private double[] actual;
    private double[] layerDelta;
    private int[] layerCounts;
    private int[] layerFeedCounts;
    private int[] layerIndex;
    private int[] weightIndex;
    private double[] layerOutput;
    private double[] layerSums;
    private double[] weights;
    private FlatNetwork flat;
    private double[] derivative;
    private MLDataSet training;
    private int outputNeuron;
    private double[] totDeriv;
    private double[] gradients;
    private double error;
    private int low;
    private int high;
    private final MLDataPair pair;

    public ChainRuleWorker(FlatNetwork theNetwork, MLDataSet theTraining, int theLow, int theHigh) {
        int weightCount = theNetwork.getWeights().length;
        this.training = theTraining;
        this.flat = theNetwork;
        this.layerDelta = new double[this.flat.getLayerOutput().length];
        this.actual = new double[this.flat.getOutputCount()];
        this.derivative = new double[weightCount];
        this.totDeriv = new double[weightCount];
        this.gradients = new double[weightCount];
        this.weights = this.flat.getWeights();
        this.layerIndex = this.flat.getLayerIndex();
        this.layerCounts = this.flat.getLayerCounts();
        this.weightIndex = this.flat.getWeightIndex();
        this.layerOutput = this.flat.getLayerOutput();
        this.layerSums = this.flat.getLayerSums();
        this.layerFeedCounts = this.flat.getLayerFeedCounts();
        this.low = theLow;
        this.high = theHigh;
        this.pair = BasicMLDataPair.createPair(this.flat.getInputCount(), this.flat.getOutputCount());
    }

    @Override
    public void run() {
        this.error = 0.0;
        EngineArray.fill(this.totDeriv, 0.0);
        EngineArray.fill(this.gradients, 0.0);
        for (int i = this.low; i <= this.high; ++i) {
            this.training.getRecord(i, this.pair);
            EngineArray.fill(this.derivative, 0.0);
            this.process(this.outputNeuron, this.pair.getInputArray(), this.pair.getIdealArray());
        }
    }

    private void process(int outputNeuron, double[] input, double[] ideal) {
        int i;
        this.flat.compute(input, this.actual);
        double e = ideal[outputNeuron] - this.actual[outputNeuron];
        this.error += e * e;
        for (i = 0; i < this.actual.length; ++i) {
            this.layerDelta[i] = i == outputNeuron ? this.flat.getActivationFunctions()[0].derivativeFunction(this.layerSums[i], this.layerOutput[i]) : 0.0;
        }
        for (i = this.flat.getBeginTraining(); i < this.flat.getEndTraining(); ++i) {
            this.processLevel(i);
        }
        for (int j = 0; j < this.weights.length; ++j) {
            int n = j;
            this.gradients[n] = this.gradients[n] + e * this.derivative[j];
            int n2 = j;
            this.totDeriv[n2] = this.totDeriv[n2] + this.derivative[j];
        }
    }

    private void processLevel(int currentLevel) {
        int fromLayerIndex = this.layerIndex[currentLevel + 1];
        int toLayerIndex = this.layerIndex[currentLevel];
        int fromLayerSize = this.layerCounts[currentLevel + 1];
        int toLayerSize = this.layerFeedCounts[currentLevel];
        int index = this.weightIndex[currentLevel];
        ActivationFunction activation = this.flat.getActivationFunctions()[currentLevel + 1];
        int yi = fromLayerIndex;
        for (int y = 0; y < fromLayerSize; ++y) {
            double output = this.layerOutput[yi];
            double sum = 0.0;
            int xi = toLayerIndex;
            int wi = index + y;
            for (int x = 0; x < toLayerSize; ++x) {
                int n = wi;
                this.derivative[n] = this.derivative[n] + output * this.layerDelta[xi];
                sum += this.weights[wi] * this.layerDelta[xi];
                wi += fromLayerSize;
                ++xi;
            }
            this.layerDelta[yi] = sum * activation.derivativeFunction(this.layerSums[yi], this.layerOutput[yi]);
            ++yi;
        }
    }

    public int getOutputNeuron() {
        return this.outputNeuron;
    }

    public void setOutputNeuron(int outputNeuron) {
        this.outputNeuron = outputNeuron;
    }

    public double[] getDerivative() {
        return this.totDeriv;
    }

    public double[] getGradients() {
        return this.gradients;
    }

    public double getError() {
        return this.error;
    }

    public FlatNetwork getNetwork() {
        return this.flat;
    }
}

