/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import java.io.Serializable;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPairCentroid;
import org.encog.util.Format;
import org.encog.util.kmeans.Centroid;

public class BasicMLDataPair
implements MLDataPair,
Serializable {
    private static final long serialVersionUID = -9068229682273861359L;
    private double significance = 1.0;
    private final MLData ideal;
    private final MLData input;

    public static MLDataPair createPair(int inputSize, int idealSize) {
        BasicMLDataPair result = idealSize > 0 ? new BasicMLDataPair(new BasicMLData(inputSize), new BasicMLData(idealSize)) : new BasicMLDataPair(new BasicMLData(inputSize));
        return result;
    }

    public BasicMLDataPair(MLData theInput) {
        this.input = theInput;
        this.ideal = null;
    }

    public BasicMLDataPair(MLData theInput, MLData theIdeal) {
        this.input = theInput;
        this.ideal = theIdeal;
    }

    @Override
    public final MLData getIdeal() {
        return this.ideal;
    }

    @Override
    public final double[] getIdealArray() {
        if (this.ideal == null) {
            return null;
        }
        return this.ideal.getData();
    }

    @Override
    public final MLData getInput() {
        return this.input;
    }

    @Override
    public final double[] getInputArray() {
        return this.input.getData();
    }

    @Override
    public final boolean isSupervised() {
        return this.ideal != null;
    }

    @Override
    public final void setIdealArray(double[] data) {
        this.ideal.setData(data);
    }

    @Override
    public final void setInputArray(double[] data) {
        this.input.setData(data);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        builder.append("Input:");
        builder.append(this.getInput());
        builder.append("Ideal:");
        builder.append(this.getIdeal());
        builder.append(",");
        builder.append("Significance:");
        builder.append(Format.formatPercent(this.significance));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public double getSignificance() {
        return this.significance;
    }

    @Override
    public void setSignificance(double significance) {
        this.significance = significance;
    }

    @Override
    public Centroid<MLDataPair> createCentroid() {
        if (!(this.input instanceof BasicMLData)) {
            throw new EncogError("The input data type of " + this.input.getClass().getSimpleName() + " must be BasicMLData.");
        }
        return new BasicMLDataPairCentroid(this);
    }
}

