/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataError;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.buffer.BufferedDataError;
import org.encog.ml.data.buffer.BufferedDataSetIterator;
import org.encog.ml.data.buffer.EncogEGBFile;

public class BufferedMLDataSet
implements MLDataSet,
Serializable {
    private static final long serialVersionUID = 2577778772598513566L;
    public static final String ERROR_ADD = "Add can only be used after calling beginLoad.";
    public static final String ERROR_REMOVE = "Remove is not supported for BufferedNeuralDataSet.";
    private transient boolean loading;
    private File file;
    private transient EncogEGBFile egb;
    private transient List<BufferedMLDataSet> additional = new ArrayList<BufferedMLDataSet>();
    private transient BufferedMLDataSet owner;

    public BufferedMLDataSet(File binaryFile) {
        this.file = binaryFile;
        this.egb = new EncogEGBFile(binaryFile);
        if (this.file.exists()) {
            this.egb.open();
        }
    }

    public final void open() {
        this.egb.open();
    }

    @Override
    public final Iterator<MLDataPair> iterator() {
        return new BufferedDataSetIterator(this);
    }

    @Override
    public final long getRecordCount() {
        if (this.egb == null) {
            return 0L;
        }
        return this.egb.getNumberOfRecords();
    }

    @Override
    public final void getRecord(long index, MLDataPair pair) {
        this.egb.setLocation((int)index);
        double[] inputTarget = pair.getInputArray();
        this.egb.read(inputTarget);
        if (pair.getIdealArray() != null) {
            double[] idealTarget = pair.getIdealArray();
            this.egb.read(idealTarget);
        }
        this.egb.read();
    }

    @Override
    public final BufferedMLDataSet openAdditional() {
        BufferedMLDataSet result = new BufferedMLDataSet(this.file);
        result.setOwner(this);
        this.additional.add(result);
        return result;
    }

    @Override
    public final void add(MLData data1) {
        if (!this.loading) {
            throw new MLDataError(ERROR_ADD);
        }
        this.egb.write(data1.getData());
        this.egb.write(1.0);
    }

    @Override
    public final void add(MLData inputData, MLData idealData) {
        if (!this.loading) {
            throw new MLDataError(ERROR_ADD);
        }
        this.egb.write(inputData.getData());
        this.egb.write(idealData.getData());
        this.egb.write(1.0);
    }

    @Override
    public final void add(MLDataPair pair) {
        if (!this.loading) {
            throw new MLDataError(ERROR_ADD);
        }
        this.egb.write(pair.getInputArray());
        this.egb.write(pair.getIdealArray());
        this.egb.write(pair.getSignificance());
    }

    @Override
    public final void close() {
        Object[] obj = this.additional.toArray();
        for (int i = 0; i < obj.length; ++i) {
            BufferedMLDataSet set = (BufferedMLDataSet)obj[i];
            set.close();
        }
        this.additional.clear();
        if (this.owner != null) {
            this.owner.removeAdditional(this);
        }
        this.egb.close();
        this.egb = null;
    }

    @Override
    public final int getIdealSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getIdealCount();
    }

    @Override
    public final int getInputSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getInputCount();
    }

    @Override
    public final boolean isSupervised() {
        if (this.egb == null) {
            return false;
        }
        return this.egb.getIdealCount() > 0;
    }

    public final BufferedMLDataSet getOwner() {
        return this.owner;
    }

    public final void setOwner(BufferedMLDataSet theOwner) {
        this.owner = theOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAdditional(BufferedMLDataSet child) {
        BufferedMLDataSet bufferedMLDataSet = this;
        synchronized (bufferedMLDataSet) {
            this.additional.remove(child);
        }
    }

    public final void beginLoad(int inputSize, int idealSize) {
        this.egb.create(inputSize, idealSize);
        this.loading = true;
    }

    public final void endLoad() {
        if (!this.loading) {
            throw new BufferedDataError("Must call beginLoad, before endLoad.");
        }
        this.egb.close();
        this.open();
    }

    public final File getFile() {
        return this.file;
    }

    public final EncogEGBFile getEGB() {
        return this.egb;
    }

    public final MLDataSet loadToMemory() {
        BasicMLDataSet result = new BasicMLDataSet();
        for (MLDataPair pair : this) {
            result.add(pair);
        }
        return result;
    }

    public final void load(MLDataSet training) {
        this.beginLoad(training.getInputSize(), training.getIdealSize());
        for (MLDataPair pair : training) {
            this.add(pair);
        }
        this.endLoad();
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        MLDataPair result = BasicMLDataPair.createPair(this.getInputSize(), this.getIdealSize());
        this.getRecord(index, result);
        return result;
    }
}

