/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.world.basic;

import java.util.Set;
import org.encog.ml.world.Action;
import org.encog.ml.world.AgentPolicy;
import org.encog.ml.world.State;
import org.encog.ml.world.SuccessorState;
import org.encog.ml.world.World;
import org.encog.ml.world.WorldAgent;

public class BasicAgent
implements WorldAgent {
    private State currentState;
    private AgentPolicy policy;
    private World world;
    private boolean first = true;

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public void setCurrentState(State s) {
        this.currentState = s;
    }

    @Override
    public AgentPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setAgentPolicy(AgentPolicy p) {
        this.policy = p;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public void tick() {
        if (this.first) {
            this.first = false;
            this.currentState.increaseVisited();
        }
        Action action = this.policy.determineNextAction(this);
        Set<SuccessorState> states = this.world.getProbability().determineSuccessorStates(this.currentState, action);
        double d = Math.random();
        double sum = 0.0;
        for (SuccessorState state : states) {
            if (!(d < (sum += state.getProbability()))) continue;
            this.currentState = state.getState();
            if (state.getState() == null) {
                System.out.println("danger");
            }
            state.getState().increaseVisited();
            return;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[BasicAgent: state=");
        result.append(this.currentState.toString());
        result.append("]");
        return result.toString();
    }
}

