/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.ml.BasicML;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNeuron;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.util.simple.EncogUtility;

public class NEATNetwork
extends BasicML
implements MLRegression,
MLError {
    private static final long serialVersionUID = 3660295468309926508L;
    public static final String PROPERTY_NETWORK_DEPTH = "depth";
    public static final String PROPERTY_LINKS = "links";
    public static final String PROPERTY_SNAPSHOT = "snapshot";
    private ActivationFunction activationFunction;
    private int networkDepth;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();
    private int inputCount;
    private int outputCount;
    private int activationCycles = 1;

    public NEATNetwork() {
    }

    public NEATNetwork(int inputCount, int outputCount, List<NEATNeuron> neurons, ActivationFunction activationFunction, int networkDepth) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.neurons.addAll(neurons);
        this.networkDepth = networkDepth;
        this.activationFunction = activationFunction;
    }

    public NEATNetwork(int inputCount, int outputCount) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.networkDepth = 0;
        this.activationFunction = new ActivationSigmoid();
    }

    @Override
    public MLData compute(MLData input) {
        BasicMLData result = new BasicMLData(this.outputCount);
        if (this.neurons.size() == 0) {
            throw new NeuralNetworkError("This network has not been evolved yet.");
        }
        for (NEATNeuron neuron : this.neurons) {
            neuron.setOutput(0.0);
        }
        for (int i = 0; i < this.activationCycles; ++i) {
            int outputIndex = 0;
            int index = 0;
            result.clear();
            while (this.neurons.get(index).getNeuronType() == NEATNeuronType.Input) {
                this.neurons.get(index).setOutput(input.getData(index));
                ++index;
            }
            this.neurons.get(index++).setOutput(1.0);
            while (index < this.neurons.size()) {
                NEATNeuron currentNeuron = this.neurons.get(index);
                double sum = 0.0;
                for (NEATLink link : currentNeuron.getInboundLinks()) {
                    double weight = link.getWeight();
                    double neuronOutput = link.getFromNeuron().getOutput();
                    sum += weight * neuronOutput;
                }
                double[] d = new double[]{sum};
                this.activationFunction.activationFunction(d, 0, d.length);
                currentNeuron.setOutput(d[0]);
                if (currentNeuron.getNeuronType() == NEATNeuronType.Output) {
                    result.setData(outputIndex++, currentNeuron.getOutput());
                }
                ++index;
            }
        }
        return result;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public void updateProperties() {
    }

    public void setInputCount(int i) {
        this.inputCount = i;
    }

    public void setOutputCount(int i) {
        this.outputCount = i;
    }

    public void setNetworkDepth(int i) {
        this.networkDepth = i;
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    public int getActivationCycles() {
        return this.activationCycles;
    }

    public void setActivationCycles(int activationCycles) {
        this.activationCycles = activationCycles;
    }
}

