/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNeuronType;

public class NEATNeuron
implements Serializable {
    public static final String NEURON_ID = "neuronID";
    private static final long serialVersionUID = -2815145950124389743L;
    private final List<NEATLink> inboundLinks = new ArrayList<NEATLink>();
    private long neuronID;
    private NEATNeuronType neuronType;
    private double output;
    private List<NEATLink> outputboundLinks = new ArrayList<NEATLink>();
    private int posX;
    private int posY;
    private double splitX;
    private double splitY;
    private double sumActivation;

    public NEATNeuron() {
    }

    public NEATNeuron(NEATNeuronType neuronType, long neuronID, double splitY, double splitX) {
        this.neuronType = neuronType;
        this.neuronID = neuronID;
        this.splitY = splitY;
        this.splitX = splitX;
        this.posX = 0;
        this.posY = 0;
        this.output = 0.0;
        this.sumActivation = 0.0;
    }

    public List<NEATLink> getInboundLinks() {
        return this.inboundLinks;
    }

    public long getNeuronID() {
        return this.neuronID;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getOutput() {
        return this.output;
    }

    public List<NEATLink> getOutputboundLinks() {
        return this.outputboundLinks;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public double getSumActivation() {
        return this.sumActivation;
    }

    public void setOutput(double output) {
        this.output = output;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATNeuron:id=");
        result.append(this.neuronID);
        result.append(",type=");
        switch (this.neuronType) {
            case Input: {
                result.append("I");
                break;
            }
            case Output: {
                result.append("O");
                break;
            }
            case Bias: {
                result.append("B");
                break;
            }
            case Hidden: {
                result.append("H");
                break;
            }
            default: {
                result.append("Unknown");
            }
        }
        result.append("]");
        return result.toString();
    }

    public static NEATNeuronType string2NeuronType(String t) {
        String type = t.toLowerCase().trim();
        if (type.length() > 0) {
            switch (type.charAt(0)) {
                case 'i': {
                    return NEATNeuronType.Input;
                }
                case 'o': {
                    return NEATNeuronType.Output;
                }
                case 'h': {
                    return NEATNeuronType.Hidden;
                }
                case 'b': {
                    return NEATNeuronType.Bias;
                }
                case 'n': {
                    return NEATNeuronType.None;
                }
            }
        }
        return null;
    }

    public static String neuronType2String(NEATNeuronType t) {
        switch (t) {
            case Input: {
                return "I";
            }
            case Bias: {
                return "B";
            }
            case Hidden: {
                return "H";
            }
            case Output: {
                return "O";
            }
            case None: {
                return "N";
            }
        }
        return null;
    }
}

