/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.ml.genetic.genes.Gene;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.innovation.Innovation;
import org.encog.ml.genetic.species.BasicSpecies;
import org.encog.ml.genetic.species.Species;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovation;
import org.encog.neural.neat.training.NEATInnovationList;
import org.encog.neural.neat.training.NEATInnovationType;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.persist.PersistError;
import org.encog.util.csv.CSVFormat;

public class PersistNEATPopulation
implements EncogPersistor {
    @Override
    public String getPersistClassString() {
        return NEATPopulation.class.getSimpleName();
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        NEATPopulation result = new NEATPopulation();
        NEATInnovationList innovationList = new NEATInnovationList();
        innovationList.setPopulation(result);
        result.setInnovations(innovationList);
        EncogReadHelper in = new EncogReadHelper(is);
        HashMap<Integer, BasicSpecies> speciesMap = new HashMap<Integer, BasicSpecies>();
        HashMap<BasicSpecies, Integer> leaderMap = new HashMap<BasicSpecies, Integer>();
        HashMap<Integer, NEATGenome> genomeMap = new HashMap<Integer, NEATGenome>();
        while ((section = in.readNextSection()) != null) {
            String[] cols;
            if (section.getSectionName().equals("NEAT-POPULATION") && section.getSubSectionName().equals("INNOVATIONS")) {
                for (String line : section.getLines()) {
                    cols = EncogFileSection.splitColumns(line);
                    NEATInnovation innovation = new NEATInnovation();
                    innovation.setInnovationID(Integer.parseInt((String)cols.get(0)));
                    innovation.setInnovationType(PersistNEATPopulation.stringToInnovationType((String)cols.get(1)));
                    innovation.setNeuronType(PersistNEATPopulation.stringToNeuronType((String)cols.get(2)));
                    innovation.setSplitX(CSVFormat.EG_FORMAT.parse((String)cols.get(3)));
                    innovation.setSplitY(CSVFormat.EG_FORMAT.parse((String)cols.get(4)));
                    innovation.setNeuronID(Integer.parseInt((String)cols.get(5)));
                    innovation.setFromNeuronID(Integer.parseInt((String)cols.get(6)));
                    innovation.setToNeuronID(Integer.parseInt((String)cols.get(7)));
                    result.getInnovations().add(innovation);
                }
                continue;
            }
            if (section.getSectionName().equals("NEAT-POPULATION") && section.getSubSectionName().equals("SPECIES")) {
                for (String line : section.getLines()) {
                    cols = line.split(",");
                    BasicSpecies species = new BasicSpecies();
                    species.setSpeciesID(Integer.parseInt(cols[0]));
                    species.setAge(Integer.parseInt(cols[1]));
                    species.setBestScore(CSVFormat.EG_FORMAT.parse(cols[2]));
                    species.setGensNoImprovement(Integer.parseInt(cols[3]));
                    species.setSpawnsRequired(CSVFormat.EG_FORMAT.parse(cols[4]));
                    species.setSpawnsRequired(CSVFormat.EG_FORMAT.parse(cols[5]));
                    leaderMap.put(species, Integer.parseInt(cols[6]));
                    result.getSpecies().add(species);
                    speciesMap.put((int)species.getSpeciesID(), species);
                }
                continue;
            }
            if (section.getSectionName().equals("NEAT-POPULATION") && section.getSubSectionName().equals("GENOMES")) {
                NEATGenome lastGenome = null;
                for (String line : section.getLines()) {
                    List<String> cols2 = EncogFileSection.splitColumns(line);
                    if (cols2.get(0).equalsIgnoreCase("g")) {
                        lastGenome = new NEATGenome();
                        lastGenome.setNeuronsChromosome(new Chromosome());
                        lastGenome.setLinksChromosome(new Chromosome());
                        lastGenome.getChromosomes().add(lastGenome.getNeuronsChromosome());
                        lastGenome.getChromosomes().add(lastGenome.getLinksChromosome());
                        lastGenome.setGenomeID(Integer.parseInt(cols2.get(1)));
                        lastGenome.setSpeciesID(Integer.parseInt(cols2.get(2)));
                        lastGenome.setAdjustedScore(CSVFormat.EG_FORMAT.parse(cols2.get(3)));
                        lastGenome.setAmountToSpawn(CSVFormat.EG_FORMAT.parse(cols2.get(4)));
                        lastGenome.setNetworkDepth(Integer.parseInt(cols2.get(5)));
                        lastGenome.setScore(CSVFormat.EG_FORMAT.parse(cols2.get(6)));
                        result.add(lastGenome);
                        genomeMap.put((int)lastGenome.getGenomeID(), lastGenome);
                        continue;
                    }
                    if (cols2.get(0).equalsIgnoreCase("n")) {
                        NEATNeuronGene neuronGene = new NEATNeuronGene();
                        neuronGene.setId(Integer.parseInt(cols2.get(1)));
                        neuronGene.setNeuronType(PersistNEATPopulation.stringToNeuronType(cols2.get(2)));
                        neuronGene.setEnabled(Integer.parseInt(cols2.get(3)) > 0);
                        neuronGene.setInnovationId(Integer.parseInt(cols2.get(4)));
                        neuronGene.setActivationResponse(CSVFormat.EG_FORMAT.parse(cols2.get(5)));
                        neuronGene.setSplitX(CSVFormat.EG_FORMAT.parse(cols2.get(6)));
                        neuronGene.setSplitY(CSVFormat.EG_FORMAT.parse(cols2.get(7)));
                        lastGenome.getNeurons().add(neuronGene);
                        continue;
                    }
                    if (!cols2.get(0).equalsIgnoreCase("l")) continue;
                    NEATLinkGene linkGene = new NEATLinkGene();
                    linkGene.setId(Integer.parseInt(cols2.get(1)));
                    linkGene.setEnabled(Integer.parseInt(cols2.get(2)) > 0);
                    linkGene.setRecurrent(Integer.parseInt(cols2.get(3)) > 0);
                    linkGene.setFromNeuronID(Integer.parseInt(cols2.get(4)));
                    linkGene.setToNeuronID(Integer.parseInt(cols2.get(5)));
                    linkGene.setWeight(CSVFormat.EG_FORMAT.parse(cols2.get(6)));
                    linkGene.setInnovationId(Integer.parseInt(cols2.get(7)));
                    lastGenome.getLinks().add(linkGene);
                }
                continue;
            }
            if (!section.getSectionName().equals("NEAT-POPULATION") || !section.getSubSectionName().equals("CONFIG")) continue;
            Map<String, String> params = section.parseParams();
            result.setNeatActivationFunction(EncogFileSection.parseActivationFunction(params, "neatAct"));
            result.setActivationCycles(EncogFileSection.parseInt(params, "cycles"));
            result.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
            result.setOutputCount(EncogFileSection.parseInt(params, "outputCount"));
            result.setOldAgePenalty(EncogFileSection.parseDouble(params, "oldAgePenalty"));
            result.setOldAgeThreshold(EncogFileSection.parseInt(params, "oldAgeThreshold"));
            result.setPopulationSize(EncogFileSection.parseInt(params, "populationSize"));
            result.setSurvivalRate(EncogFileSection.parseDouble(params, "survivalRate"));
            result.setYoungBonusAgeThreshhold(EncogFileSection.parseInt(params, "youngAgeThreshold"));
            result.setYoungScoreBonus(EncogFileSection.parseDouble(params, "youngAgeBonus"));
            result.getGenomeIDGenerate().setCurrentID(EncogFileSection.parseInt(params, "nextGenomeID"));
            result.getInnovationIDGenerate().setCurrentID(EncogFileSection.parseInt(params, "nextInnovationID"));
            result.getGeneIDGenerate().setCurrentID(EncogFileSection.parseInt(params, "nextGeneID"));
            result.getSpeciesIDGenerate().setCurrentID(EncogFileSection.parseInt(params, "nextSpeciesID"));
        }
        for (Genome genome : result.getGenomes()) {
            NEATGenome neatGenome = (NEATGenome)genome;
            int speciesId = (int)neatGenome.getSpeciesID();
            Species species = (Species)speciesMap.get(speciesId);
            if (species != null) {
                species.getMembers().add(neatGenome);
            }
            neatGenome.setInputCount(result.getInputCount());
            neatGenome.setOutputCount(result.getOutputCount());
        }
        for (Species species : leaderMap.keySet()) {
            int leaderID = (Integer)leaderMap.get(species);
            Genome leader = (Genome)genomeMap.get(leaderID);
            if (leader == null) {
                throw new PersistError("Unknown leader: genome #" + leader);
            }
            species.setLeader(leader);
            ((BasicSpecies)species).setPopulation(result);
        }
        ((NEATInnovationList)result.getInnovations()).init();
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        NEATPopulation pop = (NEATPopulation)obj;
        out.addSection("NEAT-POPULATION");
        out.addSubSection("CONFIG");
        out.writeProperty("cycles", pop.getActivationCycles());
        out.writeProperty("neatAct", pop.getNeatActivationFunction());
        out.writeProperty("inputCount", pop.getInputCount());
        out.writeProperty("outputCount", pop.getOutputCount());
        out.writeProperty("oldAgePenalty", pop.getOldAgePenalty());
        out.writeProperty("oldAgeThreshold", pop.getOldAgeThreshold());
        out.writeProperty("populationSize", pop.getPopulationSize());
        out.writeProperty("survivalRate", pop.getSurvivalRate());
        out.writeProperty("youngAgeThreshold", pop.getYoungBonusAgeThreshold());
        out.writeProperty("youngAgeBonus", pop.getYoungScoreBonus());
        out.writeProperty("nextGenomeID", pop.getGenomeIDGenerate().getCurrentID());
        out.writeProperty("nextInnovationID", pop.getInnovationIDGenerate().getCurrentID());
        out.writeProperty("nextGeneID", pop.getGeneIDGenerate().getCurrentID());
        out.writeProperty("nextSpeciesID", pop.getSpeciesIDGenerate().getCurrentID());
        out.addSubSection("INNOVATIONS");
        if (pop.getInnovations() != null) {
            for (Innovation innovation : pop.getInnovations().getInnovations()) {
                NEATInnovation neatInnovation = (NEATInnovation)innovation;
                out.addColumn(neatInnovation.getInnovationID());
                out.addColumn(PersistNEATPopulation.innovationTypeToString(neatInnovation.getInnovationType()));
                out.addColumn(PersistNEATPopulation.neuronTypeToString(neatInnovation.getNeuronType()));
                out.addColumn(neatInnovation.getSplitX());
                out.addColumn(neatInnovation.getSplitY());
                out.addColumn(neatInnovation.getNeuronID());
                out.addColumn(neatInnovation.getFromNeuronID());
                out.addColumn(neatInnovation.getToNeuronID());
                out.writeLine();
            }
        }
        out.addSubSection("GENOMES");
        for (Genome genome : pop.getGenomes()) {
            NEATGenome neatGenome = (NEATGenome)genome;
            out.addColumn("g");
            out.addColumn(neatGenome.getGenomeID());
            out.addColumn(neatGenome.getSpeciesID());
            out.addColumn(neatGenome.getAdjustedScore());
            out.addColumn(neatGenome.getAmountToSpawn());
            out.addColumn(neatGenome.getNetworkDepth());
            out.addColumn(neatGenome.getScore());
            out.writeLine();
            for (Gene neuronGene : neatGenome.getNeurons().getGenes()) {
                NEATNeuronGene neatNeuronGene = (NEATNeuronGene)neuronGene;
                out.addColumn("n");
                out.addColumn(neatNeuronGene.getId());
                out.addColumn(PersistNEATPopulation.neuronTypeToString(neatNeuronGene.getNeuronType()));
                out.addColumn(neatNeuronGene.isEnabled());
                out.addColumn(neatNeuronGene.getInnovationId());
                out.addColumn(neatNeuronGene.getActivationResponse());
                out.addColumn(neatNeuronGene.getSplitX());
                out.addColumn(neatNeuronGene.getSplitY());
                out.writeLine();
            }
            for (Gene linkGene : neatGenome.getLinks().getGenes()) {
                NEATLinkGene neatLinkGene = (NEATLinkGene)linkGene;
                out.addColumn("l");
                out.addColumn(neatLinkGene.getId());
                out.addColumn(neatLinkGene.isEnabled());
                out.addColumn(neatLinkGene.isRecurrent());
                out.addColumn(neatLinkGene.getFromNeuronID());
                out.addColumn(neatLinkGene.getToNeuronID());
                out.addColumn(neatLinkGene.getWeight());
                out.addColumn(neatLinkGene.getInnovationId());
                out.writeLine();
            }
        }
        out.addSubSection("SPECIES");
        for (Species species : pop.getSpecies()) {
            out.addColumn(species.getSpeciesID());
            out.addColumn(species.getAge());
            out.addColumn(species.getBestScore());
            out.addColumn(species.getGensNoImprovement());
            out.addColumn(species.getNumToSpawn());
            out.addColumn(species.getSpawnsRequired());
            if (species.getLeader() == null) {
                out.addColumn(-1);
            } else {
                if (!pop.getGenomes().contains(species.getLeader())) {
                    throw new PersistError("Genome #" + species.getLeader().getGenomeID() + " is a leader, but not in the general population.");
                }
                out.addColumn(species.getLeader().getGenomeID());
            }
            out.writeLine();
        }
        out.flush();
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public static String neuronTypeToString(NEATNeuronType t) {
        switch (t) {
            case Bias: {
                return "b";
            }
            case Hidden: {
                return "h";
            }
            case Input: {
                return "i";
            }
            case None: {
                return "n";
            }
            case Output: {
                return "o";
            }
        }
        return null;
    }

    public static String innovationTypeToString(NEATInnovationType t) {
        switch (t) {
            case NewLink: {
                return "l";
            }
            case NewNeuron: {
                return "n";
            }
        }
        return null;
    }

    public static NEATInnovationType stringToInnovationType(String t) {
        if (t.equalsIgnoreCase("l")) {
            return NEATInnovationType.NewLink;
        }
        if (t.equalsIgnoreCase("n")) {
            return NEATInnovationType.NewNeuron;
        }
        return null;
    }

    public static NEATNeuronType stringToNeuronType(String t) {
        if (t.equals("b")) {
            return NEATNeuronType.Bias;
        }
        if (t.equals("h")) {
            return NEATNeuronType.Hidden;
        }
        if (t.equals("i")) {
            return NEATNeuronType.Input;
        }
        if (t.equals("n")) {
            return NEATNeuronType.None;
        }
        if (t.equals("o")) {
            return NEATNeuronType.Output;
        }
        return null;
    }
}

