/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.encog.EncogError;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.genetic.genes.BasicGene;
import org.encog.ml.genetic.genes.Gene;
import org.encog.ml.genetic.genome.BasicGenome;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.NEATNeuron;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATInnovation;
import org.encog.neural.neat.training.NEATInnovationType;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.neural.neat.training.NEATTraining;

public class NEATGenome
extends BasicGenome
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NEURONS = "neurons";
    public static final String PROPERTY_LINKS = "links";
    public static final double TWEAK_DISJOINT = 1.0;
    public static final double TWEAK_EXCESS = 1.0;
    public static final double TWEAK_MATCHED = 0.4;
    private int inputCount;
    private Chromosome linksChromosome;
    private int networkDepth;
    private Chromosome neuronsChromosome;
    private int outputCount;
    private long speciesID;

    public NEATGenome(NEATGenome other) {
        BasicGene newGene;
        BasicGene oldGene;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.setGeneticAlgorithm(other.getGeneticAlgorithm());
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        this.setGenomeID(other.getGenomeID());
        this.networkDepth = other.networkDepth;
        this.setPopulation(other.getPopulation());
        this.setScore(other.getScore());
        this.setAdjustedScore(other.getAdjustedScore());
        this.setAmountToSpawn(other.getAmountToSpawn());
        this.inputCount = other.inputCount;
        this.outputCount = other.outputCount;
        this.speciesID = other.speciesID;
        for (Gene gene : other.getNeurons().getGenes()) {
            oldGene = (NEATNeuronGene)gene;
            newGene = new NEATNeuronGene(((NEATNeuronGene)oldGene).getNeuronType(), oldGene.getId(), ((NEATNeuronGene)oldGene).getSplitY(), ((NEATNeuronGene)oldGene).getSplitX(), ((NEATNeuronGene)oldGene).getActivationResponse());
            this.getNeurons().add(newGene);
        }
        for (Gene gene : other.getLinks().getGenes()) {
            oldGene = (NEATLinkGene)gene;
            newGene = new NEATLinkGene(((NEATLinkGene)oldGene).getFromNeuronID(), ((NEATLinkGene)oldGene).getToNeuronID(), oldGene.isEnabled(), oldGene.getInnovationId(), ((NEATLinkGene)oldGene).getWeight(), ((NEATLinkGene)oldGene).isRecurrent());
            this.getLinks().add(newGene);
        }
    }

    public NEATGenome(long genomeID, Chromosome neurons, Chromosome links, int inputCount, int outputCount) {
        this.setGenomeID(genomeID);
        this.linksChromosome = links;
        this.neuronsChromosome = neurons;
        this.setAmountToSpawn(0.0);
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
    }

    public NEATGenome(long id, int inputCount, int outputCount) {
        int i;
        this.setGenomeID(id);
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.setAmountToSpawn(0.0);
        this.speciesID = 0L;
        double inputRowSlice = 0.8 / (double)inputCount;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        for (int i2 = 0; i2 < inputCount; ++i2) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Input, i2, 0.0, 0.1 + (double)i2 * inputRowSlice));
        }
        this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Bias, inputCount, 0.0, 0.9));
        double outputRowSlice = 1.0 / (double)(outputCount + 1);
        for (i = 0; i < outputCount; ++i) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Output, i + inputCount + 1, 1.0, (double)(i + 1) * outputRowSlice));
        }
        for (i = 0; i < inputCount + 1; ++i) {
            for (int j = 0; j < outputCount; ++j) {
                this.linksChromosome.add(new NEATLinkGene(((NEATNeuronGene)this.neuronsChromosome.get(i)).getId(), ((NEATNeuronGene)this.getNeurons().get(inputCount + j + 1)).getId(), true, inputCount + outputCount + 1 + this.getNumGenes(), RangeRandomizer.randomize(-1.0, 1.0), false));
            }
        }
    }

    public NEATGenome() {
    }

    void addLink(double mutationRate, double chanceOfLooped, int numTrysToFindLoop, int numTrysToAddLink) {
        if (Math.random() > mutationRate) {
            return;
        }
        int countTrysToFindLoop = numTrysToFindLoop;
        int countTrysToAddLink = numTrysToFindLoop;
        long neuron1ID = -1L;
        long neuron2ID = -1L;
        boolean recurrent = false;
        while (countTrysToAddLink-- > 0) {
            NEATNeuronGene neuron1 = this.chooseRandomNeuron(true);
            NEATNeuronGene neuron2 = this.chooseRandomNeuron(false);
            if (this.isDuplicateLink(neuron1.getId(), neuron2.getId()) || neuron2.getNeuronType() == NEATNeuronType.Bias) continue;
            neuron1ID = neuron1.getId();
            neuron2ID = neuron2.getId();
            break;
        }
        if (neuron1ID < 0L || neuron2ID < 0L) {
            return;
        }
        NEATInnovation innovation = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(neuron1ID, neuron1ID, NEATInnovationType.NewLink);
        NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.get(this.getElementPos(neuron1ID));
        if (neuronGene.getSplitY() > neuronGene.getSplitY()) {
            recurrent = true;
        }
        this.validate();
        if (innovation == null) {
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(neuron1ID, neuron2ID, NEATInnovationType.NewLink);
            long id2 = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            NEATLinkGene linkGene = new NEATLinkGene(neuron1ID, neuron2ID, true, id2, RangeRandomizer.randomize(-1.0, 1.0), recurrent);
            this.linksChromosome.add(linkGene);
        } else {
            NEATLinkGene linkGene = new NEATLinkGene(neuron1ID, neuron2ID, true, innovation.getInnovationID(), RangeRandomizer.randomize(-1.0, 1.0), recurrent);
            this.linksChromosome.add(linkGene);
        }
        this.validate();
    }

    void addNeuron(double mutationRate, int numTrysToFindOldLink) {
        long newNeuronID;
        long neuronID;
        if (Math.random() > mutationRate) {
            return;
        }
        int countTrysToFindOldLink = numTrysToFindOldLink;
        BasicGene splitLink = null;
        int sizeBias = this.inputCount + this.outputCount + 10;
        int upperLimit = this.linksChromosome.size() < sizeBias ? this.getNumGenes() - 1 - (int)Math.sqrt(this.getNumGenes()) : this.getNumGenes() - 1;
        while (countTrysToFindOldLink-- > 0) {
            int i = RangeRandomizer.randomInt(0, upperLimit);
            NEATLinkGene link = (NEATLinkGene)this.linksChromosome.get(i);
            long fromNeuron = link.getFromNeuronID();
            if (!link.isEnabled() || link.isRecurrent() || ((NEATNeuronGene)this.getNeurons().get(this.getElementPos(fromNeuron))).getNeuronType() == NEATNeuronType.Bias) continue;
            splitLink = link;
            break;
        }
        if (splitLink == null) {
            return;
        }
        splitLink.setEnabled(false);
        double originalWeight = ((NEATLinkGene)splitLink).getWeight();
        long from = ((NEATLinkGene)splitLink).getFromNeuronID();
        long to = ((NEATLinkGene)splitLink).getToNeuronID();
        NEATNeuronGene fromGene = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(from));
        NEATNeuronGene toGene = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(to));
        double newDepth = (fromGene.getSplitY() + toGene.getSplitY()) / 2.0;
        double newWidth = (fromGene.getSplitX() + toGene.getSplitX()) / 2.0;
        NEATInnovation innovation = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(from, to, NEATInnovationType.NewNeuron);
        this.validate();
        if (innovation != null && this.alreadyHaveThisNeuronID(neuronID = innovation.getNeuronID())) {
            innovation = null;
        }
        if (innovation == null) {
            newNeuronID = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(from, to, NEATInnovationType.NewNeuron, NEATNeuronType.Hidden, newWidth, newDepth);
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Hidden, newNeuronID, newDepth, newWidth));
            long link1ID = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(from, newNeuronID, NEATInnovationType.NewLink);
            NEATLinkGene link1 = new NEATLinkGene(from, newNeuronID, true, link1ID, 1.0, false);
            this.validate();
            this.linksChromosome.add(link1);
            this.validate();
            long link2ID = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(newNeuronID, to, NEATInnovationType.NewLink);
            NEATLinkGene link2 = new NEATLinkGene(newNeuronID, to, true, link2ID, originalWeight, false);
            this.validate();
            this.linksChromosome.add(link2);
            this.validate();
        } else {
            newNeuronID = innovation.getNeuronID();
            NEATInnovation innovationLink1 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(from, newNeuronID, NEATInnovationType.NewLink);
            NEATInnovation innovationLink2 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(newNeuronID, to, NEATInnovationType.NewLink);
            if (innovationLink1 == null || innovationLink2 == null) {
                throw new NeuralNetworkError("NEAT Error");
            }
            NEATLinkGene link1 = new NEATLinkGene(from, newNeuronID, true, innovationLink1.getInnovationID(), 1.0, false);
            NEATLinkGene link2 = new NEATLinkGene(newNeuronID, to, true, innovationLink2.getInnovationID(), originalWeight, false);
            this.linksChromosome.add(link1);
            this.linksChromosome.add(link2);
            NEATNeuronGene newNeuron = new NEATNeuronGene(NEATNeuronType.Hidden, newNeuronID, newDepth, newWidth);
            this.validate();
            this.neuronsChromosome.add(newNeuron);
            this.validate();
        }
    }

    public boolean alreadyHaveThisNeuronID(long id) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            if (neuronGene.getId() != id) continue;
            return true;
        }
        return false;
    }

    private NEATNeuronGene chooseRandomNeuron(boolean includeInput) {
        int start = includeInput ? 0 : this.inputCount + 1;
        int neuronPos = RangeRandomizer.randomInt(start, this.getNeurons().size() - 1);
        NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.get(neuronPos);
        return neuronGene;
    }

    @Override
    public void decode() {
        this.validate();
        NEATPopulation pop = (NEATPopulation)this.getPopulation();
        ArrayList<NEATNeuron> neurons = new ArrayList<NEATNeuron>();
        for (Gene gene : this.getNeurons().getGenes()) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            NEATNeuron neuron = new NEATNeuron(neuronGene.getNeuronType(), neuronGene.getId(), neuronGene.getSplitY(), neuronGene.getSplitX());
            neurons.add(neuron);
        }
        for (Gene gene : this.getLinks().getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (!linkGene.isEnabled()) continue;
            int element = this.getElementPos(linkGene.getFromNeuronID());
            NEATNeuron fromNeuron = (NEATNeuron)neurons.get(element);
            element = this.getElementPos(linkGene.getToNeuronID());
            if (element == -1) {
                System.out.println("test");
            }
            NEATNeuron toNeuron = (NEATNeuron)neurons.get(element);
            NEATLink link = new NEATLink(linkGene.getWeight(), fromNeuron, toNeuron, linkGene.isRecurrent());
            fromNeuron.getOutputboundLinks().add(link);
            toNeuron.getInboundLinks().add(link);
        }
        NEATNetwork network = new NEATNetwork(this.inputCount, this.outputCount, neurons, pop.getNeatActivationFunction(), 0);
        network.setActivationCycles(pop.getActivationCycles());
        this.setOrganism(network);
    }

    @Override
    public void encode() {
    }

    public double getCompatibilityScore(NEATGenome genome) {
        double numDisjoint = 0.0;
        double numExcess = 0.0;
        double numMatched = 0.0;
        double weightDifference = 0.0;
        int g1 = 0;
        int g2 = 0;
        while (g1 < this.linksChromosome.size() - 1 || g2 < this.linksChromosome.size() - 1) {
            long id2;
            if (g1 == this.linksChromosome.size() - 1) {
                ++g2;
                numExcess += 1.0;
                continue;
            }
            if (g2 == genome.getLinks().size() - 1) {
                ++g1;
                numExcess += 1.0;
                continue;
            }
            long id1 = ((NEATLinkGene)this.linksChromosome.get(g1)).getInnovationId();
            if (id1 == (id2 = ((NEATLinkGene)genome.getLinks().get(g2)).getInnovationId())) {
                numMatched += 1.0;
                weightDifference += Math.abs(((NEATLinkGene)this.linksChromosome.get(++g1)).getWeight() - ((NEATLinkGene)genome.getLinks().get(++g2)).getWeight());
            }
            if (id1 < id2) {
                numDisjoint += 1.0;
                ++g1;
            }
            if (id1 <= id2) continue;
            numDisjoint += 1.0;
            ++g2;
        }
        int longest = genome.getNumGenes();
        if (this.getNumGenes() > longest) {
            longest = this.getNumGenes();
        }
        double score = 1.0 * numExcess / (double)longest + 1.0 * numDisjoint / (double)longest + 0.4 * weightDifference / numMatched;
        return score;
    }

    private int getElementPos(long neuronID) {
        for (int i = 0; i < this.getNeurons().size(); ++i) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.getGene(i);
            if (neuronGene.getId() != neuronID) continue;
            return i;
        }
        return -1;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public Chromosome getLinks() {
        return this.linksChromosome;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public Chromosome getNeurons() {
        return this.neuronsChromosome;
    }

    public int getNumGenes() {
        return this.linksChromosome.size();
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public long getSpeciesID() {
        return this.speciesID;
    }

    public double getSplitY(int nd) {
        return ((NEATNeuronGene)this.neuronsChromosome.get(nd)).getSplitY();
    }

    public boolean isDuplicateLink(long fromNeuronID, long toNeuronID) {
        for (Gene gene : this.getLinks().getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (linkGene.getFromNeuronID() != fromNeuronID || linkGene.getToNeuronID() != toNeuronID) continue;
            return true;
        }
        return false;
    }

    public void mutateActivationResponse(double mutateRate, double maxPertubation) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            if (!(Math.random() < mutateRate)) continue;
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            neuronGene.setActivationResponse(neuronGene.getActivationResponse() + RangeRandomizer.randomize(-1.0, 1.0) * maxPertubation);
        }
    }

    public void mutateWeights(double mutateRate, double probNewMutate, double maxPertubation) {
        for (Gene gene : this.linksChromosome.getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (!(Math.random() < mutateRate)) continue;
            if (Math.random() < probNewMutate) {
                linkGene.setWeight(RangeRandomizer.randomize(-1.0, 1.0));
                continue;
            }
            linkGene.setWeight(linkGene.getWeight() + RangeRandomizer.randomize(-1.0, 1.0) * maxPertubation);
        }
    }

    public void setNetworkDepth(int networkDepth) {
        this.networkDepth = networkDepth;
    }

    public void setSpeciesID(long species) {
        this.speciesID = species;
    }

    public void sortGenes() {
        Collections.sort(this.linksChromosome.getGenes());
    }

    public Chromosome getLinksChromosome() {
        return this.linksChromosome;
    }

    public void setLinksChromosome(Chromosome linksChromosome) {
        this.linksChromosome = linksChromosome;
    }

    public Chromosome getNeuronsChromosome() {
        return this.neuronsChromosome;
    }

    public void setNeuronsChromosome(Chromosome neuronsChromosome) {
        this.neuronsChromosome = neuronsChromosome;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public void validate() {
        for (int i = 0; i < this.inputCount; ++i) {
            NEATNeuronGene gene = (NEATNeuronGene)this.neuronsChromosome.getGene(i);
            if (gene.getNeuronType() == NEATNeuronType.Input) continue;
            throw new EncogError("NEAT Neuron Gene " + i + " should be an input gene.");
        }
        NEATNeuronGene g = (NEATNeuronGene)this.neuronsChromosome.getGene(this.inputCount);
        if (g.getNeuronType() != NEATNeuronType.Bias) {
            throw new EncogError("NEAT Neuron Gene " + this.inputCount + " should be a bias gene.");
        }
        for (int i = 0; i < this.inputCount; ++i) {
            NEATNeuronGene gene = (NEATNeuronGene)this.neuronsChromosome.getGene(i);
            boolean found = false;
            for (Gene lg : this.linksChromosome.getGenes()) {
                NEATLinkGene nlg = (NEATLinkGene)lg;
                if (nlg.getFromNeuronID() != gene.getId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new EncogError("Input neuron " + i + " is unconnected.");
        }
        HashMap<String, NEATLinkGene> map = new HashMap<String, NEATLinkGene>();
        for (Gene lg : this.linksChromosome.getGenes()) {
            NEATLinkGene nlg = (NEATLinkGene)lg;
            String key = nlg.getFromNeuronID() + "->" + nlg.getToNeuronID();
            if (map.containsKey(key)) {
                throw new EncogError("Double link found: " + key);
            }
            map.put(key, nlg);
        }
    }
}

