/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.randomize.NguyenWidrowRandomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLContext;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.structure.NeuralStructure;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ObjectCloner;
import org.encog.util.simple.EncogUtility;

public class BasicNetwork
extends BasicML
implements ContainsFlat,
MLContext,
MLRegression,
MLEncodable,
MLResettable,
MLClassification,
MLError {
    public static final String TAG_LIMIT = "CONNECTION_LIMIT";
    public static final double DEFAULT_CONNECTION_LIMIT = 1.0E-10;
    private static final long serialVersionUID = -136440631687066461L;
    public static final String TAG_CONNECTION_LIMIT = "connectionLimit";
    public static final String TAG_BEGIN_TRAINING = "beginTraining";
    public static final String TAG_CONTEXT_TARGET_OFFSET = "contextTargetOffset";
    public static final String TAG_CONTEXT_TARGET_SIZE = "contextTargetSize";
    public static final String TAG_END_TRAINING = "endTraining";
    public static final String TAG_HAS_CONTEXT = "hasContext";
    public static final String TAG_LAYER_COUNTS = "layerCounts";
    public static final String TAG_LAYER_FEED_COUNTS = "layerFeedCounts";
    public static final String TAG_LAYER_INDEX = "layerIndex";
    public static final String TAG_WEIGHT_INDEX = "weightIndex";
    public static final String TAG_BIAS_ACTIVATION = "biasActivation";
    public static final String TAG_LAYER_CONTEXT_COUNT = "layerContextCount";
    private final NeuralStructure structure = new NeuralStructure(this);

    public final void addLayer(Layer layer) {
        layer.setNetwork(this);
        this.structure.getLayers().add(layer);
    }

    public final void addWeight(int fromLayer, int fromNeuron, int toNeuron, double value) {
        double old = this.getWeight(fromLayer, fromNeuron, toNeuron);
        this.setWeight(fromLayer, fromNeuron, toNeuron, old + value);
    }

    @Override
    public final double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    public final int calculateNeuronCount() {
        int result = 0;
        for (Layer layer : this.structure.getLayers()) {
            result += layer.getNeuronCount();
        }
        return result;
    }

    @Override
    public final int classify(MLData input) {
        return this.winner(input);
    }

    @Override
    public final void clearContext() {
        if (this.structure.getFlat() != null) {
            this.structure.getFlat().clearContext();
        }
    }

    public final Object clone() {
        BasicNetwork result = (BasicNetwork)ObjectCloner.deepCopy(this);
        return result;
    }

    public final void compute(double[] input, double[] output) {
        BasicMLData input2 = new BasicMLData(input);
        MLData output2 = this.compute(input2);
        EngineArray.arrayCopy(output2.getData(), output);
    }

    @Override
    public final MLData compute(MLData input) {
        try {
            BasicMLData result = new BasicMLData(this.structure.getFlat().getOutputCount());
            this.structure.getFlat().compute(input.getData(), result.getData());
            return result;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NeuralNetworkError("Index exception: there was likely a mismatch between layer sizes, or the size of the input presented to the network.", ex);
        }
    }

    @Override
    public final void decodeFromArray(double[] encoded) {
        this.structure.requireFlat();
        double[] weights = this.structure.getFlat().getWeights();
        if (weights.length != encoded.length) {
            throw new NeuralNetworkError("Size mismatch, encoded array should be of length " + weights.length);
        }
        EngineArray.arrayCopy(encoded, weights);
    }

    public final String dumpWeights() {
        StringBuilder result = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, result, this.structure.getFlat().getWeights());
        return result.toString();
    }

    public final void enableConnection(int fromLayer, int fromNeuron, int toNeuron, boolean enable) {
        double value = this.getWeight(fromLayer, fromNeuron, toNeuron);
        if (enable) {
            if (!this.structure.isConnectionLimited()) {
                return;
            }
            if (Math.abs(value) < this.structure.getConnectionLimit()) {
                this.setWeight(fromLayer, fromNeuron, toNeuron, RangeRandomizer.randomize(-1.0, 1.0));
            }
        } else {
            if (!this.structure.isConnectionLimited()) {
                this.setProperty(TAG_LIMIT, 1.0E-10);
                this.structure.updateProperties();
            }
            this.setWeight(fromLayer, fromNeuron, toNeuron, 0.0);
        }
    }

    @Override
    public final int encodedArrayLength() {
        this.structure.requireFlat();
        return this.structure.getFlat().getEncodeLength();
    }

    @Override
    public final void encodeToArray(double[] encoded) {
        this.structure.requireFlat();
        double[] weights = this.structure.getFlat().getWeights();
        if (weights.length != encoded.length) {
            throw new NeuralNetworkError("Size mismatch, encoded array should be of length " + weights.length);
        }
        EngineArray.arrayCopy(weights, encoded);
    }

    public final boolean equals(BasicNetwork other) {
        return this.equals(other, 10);
    }

    public final boolean equals(BasicNetwork other, int precision) {
        return NetworkCODEC.equals(this, other, precision);
    }

    public final ActivationFunction getActivation(int layer) {
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - layer - 1;
        return this.structure.getFlat().getActivationFunctions()[layerNumber];
    }

    @Override
    public final FlatNetwork getFlat() {
        return this.getStructure().getFlat();
    }

    @Override
    public final int getInputCount() {
        this.structure.requireFlat();
        return this.getStructure().getFlat().getInputCount();
    }

    public final double getLayerBiasActivation(int l) {
        if (!this.isLayerBiased(l)) {
            throw new NeuralNetworkError("Error, the specified layer does not have a bias: " + l);
        }
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - l - 1;
        int layerOutputIndex = this.structure.getFlat().getLayerIndex()[layerNumber];
        int count = this.structure.getFlat().getLayerCounts()[layerNumber];
        return this.structure.getFlat().getLayerOutput()[layerOutputIndex + count - 1];
    }

    public final int getLayerCount() {
        this.structure.requireFlat();
        return this.structure.getFlat().getLayerCounts().length;
    }

    public final int getLayerNeuronCount(int l) {
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - l - 1;
        return this.structure.getFlat().getLayerFeedCounts()[layerNumber];
    }

    public final double getLayerOutput(int layer, int neuronNumber) {
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - layer - 1;
        int index = this.structure.getFlat().getLayerIndex()[layerNumber] + neuronNumber;
        double[] output = this.structure.getFlat().getLayerOutput();
        if (index >= output.length) {
            throw new NeuralNetworkError("The layer index: " + index + " specifies an output index larger than the network has.");
        }
        return output[index];
    }

    public final int getLayerTotalNeuronCount(int l) {
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - l - 1;
        return this.structure.getFlat().getLayerCounts()[layerNumber];
    }

    @Override
    public final int getOutputCount() {
        this.structure.requireFlat();
        return this.getStructure().getFlat().getOutputCount();
    }

    public final NeuralStructure getStructure() {
        return this.structure;
    }

    public final double getWeight(int fromLayer, int fromNeuron, int toNeuron) {
        this.structure.requireFlat();
        this.validateNeuron(fromLayer, fromNeuron);
        this.validateNeuron(fromLayer + 1, toNeuron);
        int fromLayerNumber = this.getLayerCount() - fromLayer - 1;
        int toLayerNumber = fromLayerNumber - 1;
        if (toLayerNumber < 0) {
            throw new NeuralNetworkError("The specified layer is not connected to another layer: " + fromLayer);
        }
        int weightBaseIndex = this.structure.getFlat().getWeightIndex()[toLayerNumber];
        int count = this.structure.getFlat().getLayerCounts()[fromLayerNumber];
        int weightIndex = weightBaseIndex + fromNeuron + toNeuron * count;
        return this.structure.getFlat().getWeights()[weightIndex];
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean isConnected(int layer, int fromNeuron, int toNeuron) {
        return false;
    }

    public final boolean isLayerBiased(int l) {
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - l - 1;
        return this.structure.getFlat().getLayerCounts()[layerNumber] != this.structure.getFlat().getLayerFeedCounts()[layerNumber];
    }

    @Override
    public final void reset() {
        if (this.getLayerCount() < 3) {
            new RangeRandomizer(-1.0, 1.0).randomize(this);
        } else {
            new NguyenWidrowRandomizer().randomize(this);
        }
    }

    @Override
    public final void reset(int seed) {
        this.reset();
    }

    public final void setBiasActivation(double activation) {
        if (this.structure.getFlat() == null) {
            for (Layer layer : this.structure.getLayers()) {
                if (!layer.hasBias()) continue;
                layer.setBiasActivation(activation);
            }
        } else {
            for (int i = 0; i < this.getLayerCount(); ++i) {
                if (!this.isLayerBiased(i)) continue;
                this.setLayerBiasActivation(i, activation);
            }
        }
    }

    public final void setLayerBiasActivation(int l, double value) {
        if (!this.isLayerBiased(l)) {
            throw new NeuralNetworkError("Error, the specified layer does not have a bias: " + l);
        }
        this.structure.requireFlat();
        int layerNumber = this.getLayerCount() - l - 1;
        int layerOutputIndex = this.structure.getFlat().getLayerIndex()[layerNumber];
        int count = this.structure.getFlat().getLayerCounts()[layerNumber];
        this.structure.getFlat().getLayerOutput()[layerOutputIndex + count - 1] = value;
    }

    public final void setWeight(int fromLayer, int fromNeuron, int toNeuron, double value) {
        this.structure.requireFlat();
        int fromLayerNumber = this.getLayerCount() - fromLayer - 1;
        int toLayerNumber = fromLayerNumber - 1;
        if (toLayerNumber < 0) {
            throw new NeuralNetworkError("The specified layer is not connected to another layer: " + fromLayer);
        }
        int weightBaseIndex = this.structure.getFlat().getWeightIndex()[toLayerNumber];
        int count = this.structure.getFlat().getLayerCounts()[fromLayerNumber];
        int weightIndex = weightBaseIndex + fromNeuron + toNeuron * count;
        this.structure.getFlat().getWeights()[weightIndex] = value;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[BasicNetwork: Layers=");
        int layers = 0;
        layers = this.structure.getFlat() == null ? this.structure.getLayers().size() : this.structure.getFlat().getLayerCounts().length;
        builder.append(layers);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public final void updateProperties() {
        this.structure.updateProperties();
    }

    public final void validateNeuron(int targetLayer, int neuron) {
        if (targetLayer < 0 || targetLayer >= this.getLayerCount()) {
            throw new NeuralNetworkError("Invalid layer count: " + targetLayer);
        }
        if (neuron < 0 || neuron >= this.getLayerTotalNeuronCount(targetLayer)) {
            throw new NeuralNetworkError("Invalid neuron number: " + neuron);
        }
    }

    public final int winner(MLData input) {
        MLData output = this.compute(input);
        return EngineArray.maxIndex(output.getData());
    }
}

